# Generated by 02-duckplyr_df-methods.R
#' @export
rename.duckplyr_df <- function(.data, ...) {
  loc <- tidyselect::eval_rename(expr(c(...)), .data)
  dupes <- duplicated(loc, fromLast = TRUE)
  loc <- loc[!dupes]

  # eval_rename() only returns changes
  proj <- rlang::set_names(seq_along(.data), names(.data))
  names(proj)[loc] <- names(loc)

  exprs <- exprs_from_loc(.data, proj)

  rel_try(call = list(name = "rename", x = .data, args = list(dots = enquos(...))),
    "Can't use relational with zero-column result set." = (length(exprs) == 0),
    {
      rel <- duckdb_rel_from_df(.data)
      out <- exprs_project(rel, exprs, .data)
      return(out)
    }
  )

  # dplyr forward
  rename <- dplyr$rename.data.frame
  out <- rename(.data, ...)
  return(out)

  # dplyr implementation
  loc <- tidyselect::eval_rename(expr(c(...)), .data)
  # eval_rename() only returns changes
  names <- names(.data)
  names[loc] <- names(loc)

  set_names(.data, names)
}

duckplyr_rename <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- rename(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
