# Generated by 02-duckplyr_df-methods.R
#' @export
group_by.duckplyr_df <- function(.data, ..., .add = FALSE, .drop = group_by_drop_default(.data)) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    # Always fall back to dplyr
    "Try {.code summarise(.by = ...)} or {.code mutate(.by = ...)} instead of {.code group_by()} and {.code ungroup()}." = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.data, duckplyr_error)

  group_by <- dplyr$group_by.data.frame
  out <- group_by(.data, ..., .add = .add, .drop = .drop)
  return(out)

  # dplyr implementation
  groups <- group_by_prepare(
    .data,
    ...,
    .add = .add,
    error_call = current_env()
  )
  grouped_df(groups$data, groups$group_names, .drop)
}

duckplyr_group_by <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df_impl(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_by(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
