# Generated by 02-duckplyr_df-methods.R
#' @rdname rename.duckplyr_df
#' @export
rename.duckplyr_df <- function(.data, ...) {
  loc <- tidyselect::eval_rename(expr(c(...)), .data)
  dupes <- duplicated(loc, fromLast = TRUE)
  loc <- loc[!dupes]

  # eval_rename() only returns changes
  proj <- rlang::set_names(seq_along(.data), names(.data))
  names(proj)[loc] <- names(loc)

  exprs <- exprs_from_loc(.data, proj)

  duckplyr_error <- rel_try(list(name = "rename", x = .data, args = try_list(dots = enquos(...))),
    #' @section Fallbacks:
    #' There is no DuckDB translation in `rename.duckplyr_df()`
    #' - with a selection that returns no columns.
    #'
    #' These features fall back to [dplyr::rename()], see `vignette("fallback")` for details.
    "Zero-column result set not supported." = (length(exprs) == 0),
    {
      rel <- duckdb_rel_from_df(.data)
      out <- exprs_project(rel, exprs, .data)
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.data, duckplyr_error)

  rename <- dplyr$rename.data.frame
  out <- rename(.data, ...)
  return(out)

  # dplyr implementation
  loc <- tidyselect::eval_rename(expr(c(...)), .data)
  # eval_rename() only returns changes
  names <- names(.data)
  names[loc] <- names(loc)

  set_names(.data, names)
}

duckplyr_rename <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df_impl(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- rename(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
