% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{geninv}
\alias{geninv}
\title{Moore-Penrose generalized inverse}
\usage{
geninv(X, tol = .Machine$double.eps^(2/3))
}
\arguments{
\item{X}{matrix}

\item{tol}{tolerance for determining bad entries}
}
\value{
A matrix of the same dimension as \code{X} is returned, the Moore-Penrose generalized inverse.
}
\description{
Moore-Penrose generalized inverse
}
\examples{
# create a positive definite 5x5 matrix
x <- crossprod(matrix(rnorm(25),5))
# make it singular
x[,2] <- x[,3]+x[,5]
geninv(x)
}
