% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dviCompare.R
\name{dviCompare}
\alias{dviCompare}
\title{Compare DVI approaches}
\usage{
dviCompare(
  pm,
  am,
  missing,
  true,
  refs = typedMembers(am),
  methods = 1:6,
  markers = NULL,
  threshold = 1,
  simulate = TRUE,
  db = getFreqDatabase(am),
  Nsim = 1,
  returnSims = FALSE,
  seed = NULL,
  numCores = 1,
  verbose = TRUE
)
}
\arguments{
\item{pm}{PM data: List of singletons}

\item{am}{AM data: A ped object or list of such.}

\item{missing}{Character vector with names of the missing persons.}

\item{true}{A character of the same length as \code{pm}, with the true solution,
e.g., \verb{true = c("M2", "*", "M3)} if the truth is V1 = M2 and V3 = M3.}

\item{refs}{Character vector with names of the reference individuals. By
default the typed members of \code{am}.}

\item{methods}{A subset of the numbers 1,2,3,4,5,6.}

\item{markers}{If \code{simulate = FALSE}: A vector indicating which markers
should be used.}

\item{threshold}{An LR threshold passed on to the sequential methods.}

\item{simulate}{A logical, indicating if simulations should be performed.}

\item{db}{A frequency database used for simulation, e.g.,
\code{forrel::NorwegianFrequencies}. By default the frequencies attached to \code{am}
are used.}

\item{Nsim}{A positive integer; the number of simulations.}

\item{returnSims}{A logical: If TRUE, the simulated data are returned without
any DVI comparison.}

\item{seed}{A seed for the random number generator, or NULL.}

\item{numCores}{The number of cores used in parallelisation. Default: 1.}

\item{verbose}{A logical.}
}
\value{
A list of solution frequencies for each method, and a vector of true
positive rates for each method.
}
\description{
Compare the efficiency of different computational approaches to DVI.
}
\details{
The following methods are available for comparison, through the \code{methods}
parameter:
\enumerate{
\item Sequential, without LR updates
\item Sequential, with LR updates
\item Sequential (undisputed) + joint (remaining). Always return the most likely
solution(s).
\item Joint - brute force. Always return the most likely solution(s).
\item Like 3, but return winner(s) only if LR > \code{threshold}; otherwise the empty
assignment.
\item Like 4, but return winner(s) only if LR > \code{threshold}; otherwise the empty
assignment.
}
}
\examples{

pm = example1$pm
am = example1$am
missing = example1$missing
refs = "R1"

db = forrel::NorwegianFrequencies[1:3]

# True solution
true = c("M1", "M2", "M3")

# Run comparison
\donttest{
dviCompare(pm, am, missing, refs, true = true, db = db, Nsim = 2, seed = 123)
}

# Alternatively, simulations can be done first...
sims = dviCompare(pm, am, missing, refs, true = true, simulate = TRUE,
                  db = db, Nsim = 2, seed = 123, returnSims = TRUE)

# ... and computations after:
\donttest{
dviCompare(sims$pm, sims$am, missing, refs, true = true, simulate = FALSE)
}

}
