% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetDVI.R
\name{subsetDVI}
\alias{subsetDVI}
\title{Extract a subset of a DVI dataset}
\usage{
subsetDVI(dvi, pm = NULL, am = NULL, missing = NULL, verbose = TRUE)
}
\arguments{
\item{dvi}{A \code{\link[=dviData]{dviData()}} object}

\item{pm}{A vector with names or indices of victim samples. By
default, all are included.}

\item{am}{A vector with names or indices of AM components. By
default, components without remaining missing individuals are dropped.}

\item{missing}{A vector with names or indices of missing persons. By
default, all missing persons in the remaining AM families are included.}

\item{verbose}{A logical.}
}
\value{
A \code{dviData} object.
}
\description{
Extract a subset of a DVI dataset
}
\examples{

subsetDVI(example2, pm = 1:2) |> plotDVI()
subsetDVI(example2, pm = "V1", am = 1) |> plotDVI()
subsetDVI(example2, missing = "M3") |> plotDVI()

}
