% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insight_request.R
\name{insight_replace_request}
\alias{insight_replace_request}
\title{Create insight object for insights that replace existing insights}
\usage{
insight_replace_request(title, description = NULL, image_url = NULL,
  embed_url = NULL, markdown_body = NULL, source_link = NULL,
  data_source_links = NULL)
}
\arguments{
\item{title}{Insight title}

\item{description}{Optional insight description}

\item{image_url}{URL of image representing the insight}

\item{embed_url}{URL of content to embed}

\item{markdown_body}{Markdown text containing the insight}

\item{source_link}{Permalink to source code or platform this
insight was generated with}

\item{data_source_links}{List containing one or more permalinks
to the data sources used to generate this insight}
}
\value{
Request object of type \code{insight_create_request}.
}
\description{
Create insight object for insights that replace existing insights
}
\examples{
request <- dwapi::insight_replace_request(title='A title',
  description = 'A description',
  image_url = 'https://site.org/image.png',
  source_link = 'https://site.org/data')
}
\seealso{
\code{\link{create_insight}}
}
