% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{dyCallbacks}
\alias{dyCallbacks}
\title{Callbacks for dygraph events}
\usage{
dyCallbacks(dygraph, clickCallback = NULL, drawCallback = NULL,
  highlightCallback = NULL, pointClickCallback = NULL,
  underlayCallback = NULL, unhighlightCallback = NULL,
  zoomCallback = NULL, drawHighlightPointCallback = NULL,
  drawPointCallback = NULL, annotationClickHandler = NULL,
  annotationMouseOverHandler = NULL, annotationMouseOutHandler = NULL,
  annotationDblClickHandler = NULL)
}
\arguments{
\item{dygraph}{Dygraph to add callbacks to}

\item{clickCallback}{A function to call when the canvas is clicked.}

\item{drawCallback}{When set, this callback gets called every time the 
dygraph is drawn. This includes the initial draw, after zooming and 
repeatedly while panning.}

\item{highlightCallback}{When set, this callback gets called every time a new
point is highlighted.}

\item{pointClickCallback}{A function to call when a data point is clicked. 
and the point that was clicked.}

\item{underlayCallback}{When set, this callback gets called before the chart 
is drawn.}

\item{unhighlightCallback}{When set, this callback gets called every time the
user stops highlighting any point by mousing out of the graph.}

\item{zoomCallback}{A function to call when the zoom window is changed 
(either by zooming in or out).}

\item{drawHighlightPointCallback}{Draw a custom item when a point is 
highlighted. Default is a small dot matching the series color. This method 
should constrain drawing to within pointSize pixels from (cx, cy)}

\item{drawPointCallback}{Draw a custom item when drawPoints is enabled. 
Default is a small dot matching the series color. This method should 
constrain drawing to within pointSize pixels from (cx, cy).}

\item{annotationClickHandler}{JavaScript function to call when an annotation
is clicked. This can also be specified on a per-annotation basis.}

\item{annotationMouseOverHandler}{JavaScript function to call when the mouse
hovers over an annotation. This can also be specified on a per-annotation
basis.}

\item{annotationMouseOutHandler}{JavaScript function to call when the mouse
exits an annotation. This can also be specified on a per-annotation basis.}

\item{annotationDblClickHandler}{JavaScript function to call when an
annotation is double clicked. This can also be specified on a
per-annotation basis.}
}
\value{
Dygraph with callbacks
}
\description{
Set JavaScript callbacks for various dygraph events. See the 
\href{http://dygraphs.com/options.html}{dygraph options} reference for 
additional details on the signature of each callback.
}

