/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.wbxml;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.freehep.wbxml.ExtensionHandler;
import org.freehep.wbxml.MutableAttributes;
import org.freehep.wbxml.WBXMLParser;
import org.xml.sax.SAXException;

public class DefaultExtensionHandler
implements ExtensionHandler {
    private List strings = new ArrayList();

    public void ext(int i, int tagID, int attributeID, MutableAttributes atts, List value) throws SAXException {
        throw new SAXException("Unknown extension: Ext " + i + " tagID: " + tagID + " attributeID: " + attributeID);
    }

    public void extI(int i, String s, int tagID, int attributeID, MutableAttributes atts, List value) throws SAXException {
        if (i != 0) {
            throw new SAXException("Unknown extension: ExtI " + i + " " + s + " tagID: " + tagID + " attributeID: " + attributeID);
        }
        atts.set(attributeID, s);
        this.strings.add(s);
    }

    public void extT(int i, int index, int tagID, int attributeID, MutableAttributes atts, List value) throws SAXException {
        if (i != 0) {
            throw new SAXException("Unknown extension: ExtT " + i + " " + index + " tagID: " + tagID + " attributeID: " + attributeID);
        }
        atts.set(attributeID, (String)this.strings.get(index));
    }

    public void opaque(int len, DataInputStream in, int tagID, int attributeID, MutableAttributes atts, List value) throws IOException, SAXException {
        byte type = in.readByte();
        --len;
        switch (type) {
            case 0: {
                if (len == 1) {
                    atts.set(attributeID, in.readByte() != 0);
                    --len;
                    break;
                }
                Object[] array = new boolean[len];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = in.readByte() != 0;
                    --len;
                }
                atts.set(attributeID, (boolean[])array);
                break;
            }
            case 1: {
                if (len == 1) {
                    atts.set(attributeID, in.readByte());
                    --len;
                    break;
                }
                Object[] array = new byte[len];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = in.readByte();
                    --len;
                }
                atts.set(attributeID, (byte[])array);
                break;
            }
            case 2: {
                if (len == 2) {
                    atts.set(attributeID, in.readChar());
                    len -= 2;
                    break;
                }
                Object[] array = new char[len / 2];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = in.readChar();
                    len -= 2;
                }
                atts.set(attributeID, (char[])array);
                break;
            }
            case 3: {
                if (len == 8) {
                    atts.set(attributeID, in.readDouble());
                    len -= 8;
                    break;
                }
                Object[] array = new double[len / 8];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = in.readDouble();
                    len -= 8;
                }
                atts.set(attributeID, (double[])array);
                break;
            }
            case 4: {
                if (len == 4) {
                    atts.set(attributeID, in.readFloat());
                    len -= 4;
                    break;
                }
                Object[] array = new float[len / 4];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = in.readFloat();
                    len -= 4;
                }
                atts.set(attributeID, (float[])array);
                break;
            }
            case 5: {
                if (len == 4) {
                    atts.set(attributeID, in.readInt());
                    len -= 4;
                    break;
                }
                Object[] array = new int[len / 4];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = in.readInt();
                    len -= 4;
                }
                atts.set(attributeID, (int[])array);
                break;
            }
            case 6: {
                if (len == 8) {
                    atts.set(attributeID, in.readLong());
                    len -= 8;
                    break;
                }
                Object[] array = new long[len / 8];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = in.readLong();
                    len -= 8;
                }
                atts.set(attributeID, (long[])array);
                break;
            }
            case 7: {
                if (len == 2) {
                    atts.set(attributeID, in.readShort());
                    len -= 2;
                    break;
                }
                Object[] array = new short[len / 2];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = in.readShort();
                    len -= 2;
                }
                atts.set(attributeID, (short[])array);
                break;
            }
            case 8: {
                ArrayList<String> strings = new ArrayList<String>();
                while (len > 0) {
                    String s = in.readUTF();
                    in.readByte();
                    strings.add(s);
                    len -= WBXMLParser.stringUTFLength(s) + 2 + 1;
                }
                if (strings.size() == 1) {
                    atts.set(attributeID, (String)strings.get(0));
                    break;
                }
                String[] array = new String[strings.size()];
                array = strings.toArray(array);
                atts.set(attributeID, array);
                break;
            }
            default: {
                System.err.println("Unknown extension: Opaque " + len + " tagID: " + tagID + " attributeID: " + attributeID);
            }
        }
        if (len > 0) {
            System.err.println("Skipping " + len + " unused OPAQUE bytes...");
            while (len > 0) {
                in.readByte();
                --len;
            }
        }
    }
}

