/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Handle;
import jas.hist.SliceData;
import jas.hist.SliceParameters;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.PlotGraphics;
import java.awt.Color;

class ProjectionData
extends SliceData {
    ProjectionData(SliceParameters p) {
        super(p);
    }

    void paint(PlotGraphics g, DoubleCoordinateTransformation xt, DoubleCoordinateTransformation yt) {
        double dx;
        double dy;
        double phi = 1.5707963267948966 + this.parm.getPhi() + Math.PI * 2;
        double phi0 = Math.atan2(xt.getPlotMax() - xt.getPlotMin(), yt.getPlotMax() - yt.getPlotMin()) + Math.PI * 2;
        double yc = (yt.getPlotMin() + yt.getPlotMax()) / 2.0;
        double xc = (xt.getPlotMin() + xt.getPlotMax()) / 2.0;
        if ((phi %= Math.PI) < (phi0 %= Math.PI) || phi > Math.PI - phi0) {
            dy = yc - yt.getPlotMin();
            dx = -dy * Math.tan(phi);
        } else {
            dx = xc - xt.getPlotMin();
            dy = dx * Math.tan(phi - 1.5707963267948966);
        }
        g.setColor(Color.black);
        g.drawLine(xc - dx, yc - dy, xc + dx, yc + dy);
    }

    public Handle[] getHandles(double xlow, double xhigh, double ylow, double yhigh) {
        double x;
        double y;
        double xc = (xlow + xhigh) / 2.0;
        double yc = (ylow + yhigh) / 2.0;
        double dx = (xhigh - xlow) / 4.0;
        double dy = (yhigh - ylow) / 4.0;
        double phi0 = Math.atan2(dx, dy) + Math.PI * 2;
        double phi = 1.5707963267948966 + this.parm.getPhi() + Math.PI * 2;
        if ((phi %= Math.PI) < (phi0 %= Math.PI) || phi > Math.PI - phi0) {
            y = yc + dy;
            x = xc - dy * Math.tan(phi);
        } else {
            x = xc + dx;
            y = yc + dx * Math.tan(phi - 1.5707963267948966);
        }
        Handle[] result = new Handle[]{new ProjectionHandle(x, y, xc, yc)};
        return result;
    }

    private class ProjectionHandle
    extends Handle {
        private double x;
        private double y;
        private double xc;
        private double yc;

        ProjectionHandle(double x, double y, double xc, double yc) {
            this.x = x;
            this.y = y;
            this.xc = xc;
            this.yc = yc;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void moveTo(double xNew, double yNew) {
            this.x = xNew;
            this.y = yNew;
            double phiNew = Math.atan2(yNew - this.yc, xNew - this.xc);
            ProjectionData.this.parm.setPhi(phiNew);
        }
    }
}

