/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.ARGBColorChooserPanel;
import jas.util.Application;
import jas.util.ColorEvent;
import jas.util.ColorListener;
import jas.util.UserProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class ColorChooser
extends JButton {
    private UserProperties m_prop;
    private String m_key;
    private Color m_color;
    private Vector m_listeners = new Vector();

    public ColorChooser() {
        this(Color.black);
    }

    public ColorChooser(Color c) {
        this.m_color = c;
        this.setIcon(new ColorChooserIcon());
    }

    public ColorChooser(String key) {
        this();
        this.m_prop = Application.getApplication().getUserProperties();
        this.m_key = key;
        this.setColor(this.m_prop.getColor(key, Color.black));
    }

    public void setColor(Color c) {
        this.m_color = c;
        this.repaint();
        Enumeration e = this.m_listeners.elements();
        while (e.hasMoreElements()) {
            ColorListener l = (ColorListener)e.nextElement();
            l.colorChanged(new ColorEvent((Object)this, c));
        }
    }

    public Color getColor() {
        return this.m_color;
    }

    public void addColorListener(ColorListener l) {
        this.m_listeners.addElement(l);
    }

    public void removeColorListener(ColorListener l) {
        this.m_listeners.removeElement(l);
    }

    protected void fireActionPerformed(ActionEvent e) {
        int rc;
        JColorChooser chooser = new JColorChooser(this.m_color);
        chooser.addChooserPanel(new ARGBColorChooserPanel());
        if (this.m_color.getAlpha() != 255) {
            AbstractColorChooserPanel[] panels = chooser.getChooserPanels();
            int l = panels.length;
            AbstractColorChooserPanel[] newpanels = new AbstractColorChooserPanel[l];
            for (int i = 1; i < l; ++i) {
                newpanels[i] = panels[i - 1];
            }
            newpanels[0] = panels[l - 1];
            chooser.setChooserPanels(newpanels);
        }
        if ((rc = JOptionPane.showOptionDialog(this, chooser, "Choose color...", 2, -1, null, null, null)) == 0) {
            Color c = chooser.getColor();
            this.setColor(c);
            if (this.m_key != null) {
                this.m_prop.setColor(this.m_key, c);
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(20, 20);
    }

    private class ColorChooserIcon
    implements Icon {
        private ColorChooserIcon() {
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics g, int x, int y) {
            g.setColor(ColorChooser.this.m_color);
            g.fillRect(x, y, 16, 16);
        }
    }
}

