/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Continue;
import don.ContinueAnalysee;
import don.DonneeID;
import don.Groupe;
import don.Modalite;
import don.Nominale;
import don.Partitionnable;
import don.Qualifiable;
import java.util.HashMap;

public abstract class QualifiableRepresentable
extends Partitionnable
implements Qualifiable {
    private HashMap<Modalite, Double> val_descMod = new HashMap();
    private HashMap<ContinueAnalysee, Double> val_descCont = new HashMap();
    private HashMap<Nominale, Double> val_descNom = new HashMap();

    public QualifiableRepresentable(String annotation, boolean active, Groupe gr, double[] coord, double[] cos2, double[] contrib, int generation) {
        super(annotation, active, gr, coord, cos2, contrib, generation);
    }

    public double getDescMod(Modalite mod) {
        Double val = this.val_descMod.get(mod);
        if (val == null) {
            return 0.0;
        }
        return val;
    }

    public void setDescMod(Modalite mod, Double vtest) {
        this.val_descMod.put(mod, vtest);
    }

    public double getDescCont(ContinueAnalysee cont) {
        Double val = this.val_descCont.get(cont);
        if (val == null) {
            return 0.0;
        }
        return val;
    }

    public void setDescCont(ContinueAnalysee cont, Double vtest) {
        this.val_descCont.put(cont, vtest);
    }

    public double getDescNom(Nominale nom) {
        Double val = this.val_descNom.get(nom);
        if (val == null) {
            return 0.0;
        }
        return val;
    }

    public void setDescNom(Nominale nom, Double vtest) {
        this.val_descNom.put(nom, vtest);
    }

    public double getDesc(DonneeID don) {
        if (don instanceof Modalite) {
            return this.getDescMod((Modalite)don);
        }
        if (don instanceof ContinueAnalysee) {
            return this.getDescCont((ContinueAnalysee)don);
        }
        return 0.0;
    }

    public double getDesc(Nominale don) {
        return this.getDescNom(don);
    }

    public String toString() {
        String chaine = String.valueOf(super.toString()) + "\n v-tests pour les modalites :\n";
        for (QualifiableRepresentable qualifiableRepresentable : this.val_descMod.keySet()) {
            chaine = String.valueOf(chaine) + qualifiableRepresentable.getAnnotation() + " : " + this.val_descMod.get(qualifiableRepresentable) + " | ";
        }
        chaine = String.valueOf(chaine) + "\n v-tests pour les continues :\n";
        for (Continue continue_ : this.val_descCont.keySet()) {
            chaine = String.valueOf(chaine) + continue_.getAnnotation() + " : " + this.val_descCont.get(continue_) + " | ";
        }
        chaine = String.valueOf(chaine) + "\n v-tests pour les nominales :\n";
        for (Nominale nominale : this.val_descNom.keySet()) {
            chaine = String.valueOf(chaine) + nominale.getAnnotation() + " : " + this.val_descNom.get(nominale) + " | ";
        }
        return chaine;
    }
}

