/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.DataSourceMenuFactory;
import jas.hist.HasScatterPlotData;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist;
import jas.hist.JASHist2DHistogramData;
import jas.hist.JASHist2DHistogramStyle;
import jas.hist.JASHist2DScatterData;
import jas.hist.JASHistData;
import jas.hist.JASHistScatterPlotData;
import jas.hist.JASHistScatterPlotStyle;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.ScatterPlotSource;
import jas.hist.SpecialComponent;
import jas.hist.StatisticsBlock;
import jas.hist.TwoDDataManager;
import jas.plot.DataArea;
import jas.plot.DoubleAxis;
import jas.plot.Legend;
import jas.plot.LegendEntry;
import jas.util.ColorMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.DefaultColorSelectionModel;

abstract class ScatterDataManager
extends TwoDDataManager {
    private int oldStyle = -1;
    private final int m_defaultNumberOfBins;
    protected transient double xLow;
    protected transient double xHigh;
    protected transient double yLow;
    protected transient double yHigh;
    private DoubleAxis xAxis = new DoubleAxis();
    private DoubleAxis yAxis = new DoubleAxis();
    private transient boolean styleChanged;
    private SizeMenu m_sizeMenu;
    private StyleMenu m_styleMenu;
    private static boolean enabled3d;

    ScatterDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats) {
        super(plot, da, l, stats);
        this.m_defaultNumberOfBins = 40;
        this.xm.setDataManager(this, true, this.xAxis);
        this.ym[0].setDataManager(this, true, this.yAxis);
        this.xm.setBins(this.m_defaultNumberOfBins);
        this.ym[0].setBins(this.m_defaultNumberOfBins);
    }

    void styleUpdate(JASHistData source) {
        this.styleChanged = true;
        JASHist2DHistogramStyle style = (JASHist2DHistogramStyle)source.getStyle();
        if (this.oldStyle != style.getHistStyle()) {
            boolean lego = style.getHistStyle() == 3;
            boolean surface = style.getHistStyle() == 4;
            try {
                if (lego) {
                    Class<?> klass = Class.forName("gov.fnal.plot3d.jas.SpecialLego");
                    SpecialComponent special = (SpecialComponent)klass.newInstance();
                    special.setData(source.getDataSource());
                    this.da.setSpecialComponent(special.getDisplayComponent());
                } else if (surface) {
                    Class<?> klass = Class.forName("gov.fnal.plot3d.jas.SpecialSurface");
                    SpecialComponent special = (SpecialComponent)klass.newInstance();
                    special.setData(source.getDataSource());
                    this.da.setSpecialComponent(special.getDisplayComponent());
                } else {
                    this.da.setSpecialComponent(null);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.da.setSpecialComponent(null);
            }
            this.oldStyle = style.getHistStyle();
        }
        SwingUtilities.invokeLater(this);
    }

    final void init() {
        this.computeXAxisRange();
        this.XAxisUpdated();
        this.computeYAxisRange();
        this.YAxisUpdated();
        this.computeZAxisRange();
        this.isInit = true;
    }

    void axisChanged(JASHistData source) {
        int index = source.getYAxis();
        if (this.ym[index] == null) {
            this.createYAxis(index);
            ((DoubleAxis)this.ym[index].getType()).setUseSuggestedRange(false);
        } else {
            this.ym[index].setAttentionNeeded();
        }
        SwingUtilities.invokeLater(this);
    }

    void update(HistogramUpdate update, JASHistData ds) {
        JASHist2DHistogramData source = (JASHist2DHistogramData)ds;
        int index = source.getYAxis();
        if (update.isRangeUpdate()) {
            if (update.axisIsSet(update.HORIZONTAL_AXIS)) {
                this.xm.setAttentionNeeded();
            }
            if (update.axisIsSet(update.VERTICAL_AXIS)) {
                this.ym[index].setAttentionNeeded();
            }
        } else if (update.isReset()) {
            this.xm.setAttentionNeeded();
            this.ym[index].setAttentionNeeded();
        } else if (update.isDataUpdate()) {
            this.xm.setAttentionNeeded();
            this.ym[index].setAttentionNeeded();
        }
        if (update.isFinalUpdate() || update.isReset()) {
            SwingUtilities.invokeLater(this);
        } else {
            this.timer.start();
        }
    }

    protected void doUpdate() {
        if (this.isInit) {
            int index;
            boolean axisChanged = false;
            if (this.xm.needsAttention()) {
                this.computeXAxisRange();
                this.XAxisUpdated();
                axisChanged = true;
            }
            if (this.ym[index = 0].needsAttention()) {
                this.computeYAxisRange();
                this.YAxisUpdated();
                axisChanged = true;
            }
            this.computeZAxisRange();
            Enumeration e = this.data.elements();
            while (e.hasMoreElements()) {
                boolean needNewEnumeration;
                Object o = e.nextElement();
                if (!(o instanceof JASHist2DScatterData)) continue;
                JASHist2DScatterData scatData = (JASHist2DScatterData)o;
                boolean bl = needNewEnumeration = axisChanged || scatData.resetSent || scatData.onNewAxis;
                if (needNewEnumeration || this.styleChanged) {
                    scatData.restartImage(needNewEnumeration);
                    scatData.onNewAxis = false;
                    scatData.resetSent = false;
                    continue;
                }
                if (!scatData.dataChanged) continue;
                scatData.continueImage();
                scatData.dataChanged = false;
            }
            this.da.validate();
            this.da.repaint();
            this.styleChanged = false;
        }
    }

    JASHistData add(DataSource ds) {
        this.da.setSpecialComponent(null);
        this.oldStyle = -1;
        if (ds instanceof HasScatterPlotData && ((HasScatterPlotData)ds).hasScatterPlotData()) {
            HasScatterPlotData source = (HasScatterPlotData)ds;
            JASHist2DScatterData d = new JASHist2DScatterData((DataManager)this, source);
            this.data.addElement(d);
            return d;
        }
        if (ds instanceof Rebinnable2DHistogramData) {
            Rebinnable2DHistogramData source = (Rebinnable2DHistogramData)ds;
            JASHist2DHistogramData d = new JASHist2DHistogramData(this, source);
            this.data.addElement(d);
            return d;
        }
        if (ds instanceof ScatterPlotSource) {
            ScatterPlotSource source = (ScatterPlotSource)ds;
            JASHistScatterPlotData d = new JASHistScatterPlotData((DataManager)this, source);
            this.data.addElement(d);
            return d;
        }
        throw new RuntimeException("Unknown subtype of DataSource added to ScatterDataManager");
    }

    void computeXAxisRange() {
        if (!this.xm.needsAttention()) {
            return;
        }
        this.xm.payingAttention();
        if (this.data.isEmpty()) {
            return;
        }
        if (!this.xm.getRangeAutomatic() || this.xm.isFixed()) {
            this.xLow = this.xm.getMin();
            this.xHigh = this.xm.getMax();
            return;
        }
        int nShowing = 0;
        this.xLow = 0.0;
        this.xHigh = 0.0;
        boolean hasRebinnables = false;
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            JASHist2DHistogramData dw = (JASHist2DHistogramData)e.nextElement();
            if (!dw.isShowing()) continue;
            if (nShowing++ == 0) {
                this.xLow = dw.getXMin();
                this.xHigh = dw.getXMax();
            } else {
                this.xLow = Math.min(this.xLow, dw.getXMin());
                this.xHigh = Math.max(this.xHigh, dw.getXMax());
            }
            if (!dw.isRebinnable()) continue;
            hasRebinnables = true;
        }
        if (nShowing == 0) {
            return;
        }
        this.xm.setBinned(hasRebinnables);
        if (!this.xm.getAllowSuppressedZero()) {
            if (this.xLow > 0.0) {
                this.xLow = 0.0;
            }
            if (this.xHigh < 0.0) {
                this.xHigh = 0.0;
            }
        }
        if (this.xHigh <= this.xLow) {
            this.xHigh = this.xLow + 1.0;
        }
        this.calcMinMaxXBins(this.xLow, this.xHigh);
    }

    protected void calcMinMaxXBins(double x1, double x2) {
        double oldXMin = this.xAxis.getPlotMin();
        double oldXMax = this.xAxis.getPlotMax();
        if (x1 != oldXMin || x2 != oldXMax) {
            this.xAxis.setMin(x1);
            this.xAxis.setMax(x2);
            this.xm.invalidate();
        }
    }

    void computeYAxisRange() {
        int index = 0;
        if (!this.ym[index].needsAttention()) {
            return;
        }
        this.ym[index].payingAttention();
        if (this.data.isEmpty()) {
            return;
        }
        if (!this.ym[index].getRangeAutomatic() || this.ym[index].isFixed()) {
            this.yLow = this.ym[index].getMin();
            this.yHigh = this.ym[index].getMax();
            return;
        }
        int nShowing = 0;
        this.yLow = 0.0;
        this.yHigh = 0.0;
        boolean hasRebinnables = false;
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            JASHist2DHistogramData dw = (JASHist2DHistogramData)e.nextElement();
            if (!dw.isShowing()) continue;
            if (nShowing++ == 0) {
                this.yLow = dw.getYMin();
                this.yHigh = dw.getYMax();
            } else {
                this.yLow = Math.min(this.yLow, dw.getYMin());
                this.yHigh = Math.max(this.yHigh, dw.getYMax());
            }
            if (!dw.isRebinnable()) continue;
            hasRebinnables = true;
        }
        if (nShowing == 0) {
            return;
        }
        this.ym[index].setBinned(hasRebinnables);
        if (!this.ym[index].getAllowSuppressedZero()) {
            if (this.yLow > 0.0) {
                this.yLow = 0.0;
            }
            if (this.yHigh < 0.0) {
                this.yHigh = 0.0;
            }
        }
        if (this.yHigh <= this.yLow) {
            this.yHigh = this.yLow + 1.0;
        }
        this.calcMinMaxYBins(this.yLow, this.yHigh);
    }

    protected void calcMinMaxYBins(double y1, double y2) {
        double oldYMin = this.yAxis.getPlotMin();
        double oldYMax = this.yAxis.getPlotMax();
        if (y1 != oldYMin || y2 != oldYMax) {
            this.yAxis.setMin(y1);
            this.yAxis.setMax(y2);
            this.ym[0].invalidate();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.data = new Vector();
    }

    final void requestShow(JASHistData data) {
        LegendEntry le;
        this.da.add(data.getOverlay());
        ++this.nVisible;
        if (this.legend != null && (le = data.getLegendEntry()) != null) {
            this.legend.add(le);
            ++this.nVisibleLegend;
            this.showLegend();
        }
        if (this.stats != null) {
            this.stats.add(data);
        }
        if (this.isInit) {
            this.xm.setAttentionNeeded();
            this.computeXAxisRange();
            this.XAxisUpdated();
            this.ym[0].setAttentionNeeded();
            this.computeYAxisRange();
            this.YAxisUpdated();
            this.computeZAxisRange();
            this.da.revalidate();
            this.da.repaint();
        }
    }

    void requestHide(JASHistData data) {
        LegendEntry le;
        this.da.remove(data.getOverlay());
        --this.nVisible;
        if (this.legend != null && (le = data.getLegendEntry()) != null) {
            this.legend.remove(le);
            --this.nVisibleLegend;
            this.showLegend();
        }
        if (this.stats != null) {
            this.stats.remove(data);
        }
        if (this.isInit) {
            this.xm.setAttentionNeeded();
            this.computeXAxisRange();
            this.XAxisUpdated();
            this.ym[0].setAttentionNeeded();
            this.computeYAxisRange();
            this.YAxisUpdated();
            this.computeZAxisRange();
            this.da.revalidate();
            this.da.repaint();
        }
    }

    void XAxisUpdated() {
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            JASHist2DHistogramData dw = (JASHist2DHistogramData)e.nextElement();
            if (!dw.isShowing()) continue;
            dw.setXRange(this.xm.getBins(), this.xLow, this.xHigh);
        }
    }

    void YAxisUpdated() {
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            JASHist2DHistogramData dw = (JASHist2DHistogramData)e.nextElement();
            if (!dw.isShowing()) continue;
            dw.setYRange(this.ym[0].getBins(), this.yLow, this.yHigh);
        }
    }

    private final void computeZAxisRange() {
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            JASHist2DHistogramData dw = (JASHist2DHistogramData)e.nextElement();
            if (!dw.isShowing()) continue;
            dw.calcZLimits();
        }
    }

    private void restartImages() {
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            try {
                JASHist2DScatterData data = (JASHist2DScatterData)e.nextElement();
                if (!data.isVisible) continue;
                data.restartImage(false);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    final void modifyPopupMenu(JPopupMenu menu, Component source) {
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        }
        boolean scat = false;
        boolean allScat = true;
        boolean allTwoD = true;
        Enumeration enumer = this.getDataSources();
        while (enumer.hasMoreElements()) {
            JASHistData data = (JASHistData)enumer.nextElement();
            if (!(data instanceof JASHist2DScatterData) || !((JASHist2DScatterData)data).hasScatterPlotData()) continue;
            scat = true;
            JASHistScatterPlotStyle pstyle = (JASHistScatterPlotStyle)data.getStyle();
            if (pstyle.getDisplayAsScatterPlot()) {
                allTwoD = false;
                continue;
            }
            allScat = false;
        }
        if (scat) {
            JRadioButtonMenuItem b1 = new JRadioButtonMenuItem("Display As Scatter Plot");
            JRadioButtonMenuItem b2 = new JRadioButtonMenuItem("Display As Binned Plot");
            ButtonGroup bg = new ButtonGroup();
            bg.add(b1);
            bg.add(b2);
            b1.setSelected(allScat);
            b2.setSelected(allTwoD);
            b1.addActionListener(new ScatterActionListener(true));
            b2.addActionListener(new ScatterActionListener(false));
            menu.add(b1);
            menu.add(b2);
        }
        if (!scat || !allScat) {
            menu.add(this.addPerDataSourceMenu("Plot Style", new DataSourceMenuFactory(){

                public JMenu createMenu(String name, JASHistData ds) {
                    return new StyleMenu(name, ds);
                }
            }));
        }
        if (scat && !allTwoD) {
            if (this.m_sizeMenu == null) {
                this.m_sizeMenu = new SizeMenu();
            }
            this.m_sizeMenu.init();
            menu.add(this.m_sizeMenu);
            menu.add(this.addPerDataSourceMenu("Point Color", new DataSourceMenuFactory(){

                public JMenu createMenu(String name, JASHistData ds) {
                    final JASHistScatterPlotStyle style = (JASHistScatterPlotStyle)ds.getStyle();
                    DefaultColorSelectionModel cm = new DefaultColorSelectionModel(){

                        public Color getSelectedColor() {
                            return style.getDataPointColor();
                        }

                        public void setSelectedColor(Color c) {
                            style.setDataPointColor(c);
                        }
                    };
                    return new ColorMenu(name, cm, true);
                }
            }));
        }
        super.modifyPopupMenu(menu, source);
    }

    static {
        try {
            Class.forName("javax.media.j3d.Canvas3D");
            Class.forName("gov.fnal.plot3d.jas.SpecialLego");
            Class.forName("gov.fnal.plot3d.jas.SpecialSurface");
            enabled3d = true;
            if (JPopupMenu.getDefaultLightWeightPopupEnabled()) {
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            }
        }
        catch (Throwable t) {
            enabled3d = false;
        }
    }

    private final class StyleMenu
    extends JMenu {
        ButtonGroup group;
        JASHistData data;

        public StyleMenu(String name, JASHistData ds) {
            super(name);
            this.group = new ButtonGroup();
            this.data = ds;
            JMenu map = new JMenu("Color Map");
            map.setMnemonic('M');
            this.add(this.addButton("Box", 'B', 0, -1));
            this.add(this.addButton("Ellipse", 'E', 1, -1));
            if (enabled3d) {
                this.add(this.addButton("3D Lego Plot", 'L', 3, -1));
                this.add(this.addButton("3D Surface Plot", 'S', 4, -1));
            }
            this.add(map);
            map.add(this.addButton("Warm", 'W', 2, 0));
            map.add(this.addButton("Cool", 'C', 2, 1));
            map.add(this.addButton("Thermal", 'T', 2, 2));
            map.add(this.addButton("Rainbow", 'B', 2, 3));
            map.add(this.addButton("Gray Scale", 'G', 2, 4));
            final JCheckBoxMenuItem log = new JCheckBoxMenuItem("Logarithmic Z Axis");
            log.setMnemonic('Z');
            final JASHist2DHistogramStyle style = (JASHist2DHistogramStyle)this.data.getStyle();
            log.setState(style.getLogZ());
            log.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    style.setLogZ(log.getState());
                }
            });
            this.add(log);
            this.init();
        }

        private JRadioButtonMenuItem addButton(String name, char mnemonic, int iStyle, int cStyle) {
            StyleButton item = new StyleButton(name, iStyle, cStyle);
            item.setMnemonic(mnemonic);
            this.group.add(item);
            return item;
        }

        private void init() {
            int iStyle = -1;
            int cStyle = -1;
            JASHist2DHistogramStyle style = (JASHist2DHistogramStyle)this.data.getStyle();
            iStyle = style.getHistStyle();
            cStyle = style.getColorMapScheme();
            Enumeration<AbstractButton> e = this.group.getElements();
            while (e.hasMoreElements()) {
                StyleButton b = (StyleButton)e.nextElement();
                b.setStyle(iStyle, cStyle);
            }
        }

        final class StyleButton
        extends JRadioButtonMenuItem {
            private int iStyle;
            private int cStyle;

            StyleButton(String name, int iStyle, int cStyle) {
                super(name);
                this.iStyle = iStyle;
                this.cStyle = cStyle;
            }

            public void fireActionPerformed(ActionEvent e) {
                JASHist2DHistogramStyle style = (JASHist2DHistogramStyle)StyleMenu.this.data.getStyle();
                style.setHistStyle(this.iStyle);
                if (this.cStyle >= 0) {
                    style.setColorMapScheme(this.cStyle);
                }
            }

            void setStyle(int iStyle, int cStyle) {
                this.setSelected(this.iStyle == iStyle && (this.cStyle == -1 || this.cStyle == cStyle));
            }
        }
    }

    final class SizeButton
    extends JRadioButtonMenuItem {
        private int size;

        SizeButton(String name, int size) {
            super(name);
            this.size = size;
        }

        public void fireActionPerformed(ActionEvent e) {
            Enumeration enumer = ScatterDataManager.this.getDataSources();
            while (enumer.hasMoreElements()) {
                JASHistData data = (JASHistData)enumer.nextElement();
                JASHistScatterPlotStyle style = (JASHistScatterPlotStyle)data.getStyle();
                style.setDataPointSize(this.size);
            }
        }

        void setSize(int size) {
            this.setSelected(this.size == size);
        }
    }

    private final class SizeMenu
    extends JMenu {
        ButtonGroup group;

        public SizeMenu() {
            super("Point Size");
            this.group = new ButtonGroup();
            this.setMnemonic('S');
            this.addButton("Huge", 'H', 20);
            this.addButton("Large", 'L', 10);
            this.addButton("Medium", 'M', 5);
            this.addButton("Small", 'S', 3);
            this.addButton("Tiny", 'T', 1);
        }

        private void addButton(String name, char mnemonic, int size) {
            SizeButton item = new SizeButton(name, size);
            item.setMnemonic(mnemonic);
            this.group.add(item);
            this.add(item);
        }

        public void init() {
            int iSize = -1;
            Enumeration enumer = ScatterDataManager.this.getDataSources();
            while (enumer.hasMoreElements()) {
                JASHistData data = (JASHistData)enumer.nextElement();
                if (!(data instanceof JASHist2DScatterData)) continue;
                JASHistScatterPlotStyle style = (JASHistScatterPlotStyle)data.getStyle();
                if (iSize == -1) {
                    iSize = style.getDataPointSize();
                    continue;
                }
                if (iSize == style.getDataPointSize()) continue;
                iSize = -2;
            }
            Enumeration<AbstractButton> e = this.group.getElements();
            while (e.hasMoreElements()) {
                SizeButton b = (SizeButton)e.nextElement();
                b.setSize(iSize);
            }
        }
    }

    private final class ScatterActionListener
    implements ActionListener {
        private boolean state;

        ScatterActionListener(boolean state) {
            this.state = state;
        }

        public void actionPerformed(ActionEvent e) {
            Enumeration enumer = ScatterDataManager.this.getDataSources();
            while (enumer.hasMoreElements()) {
                JASHistData data = (JASHistData)enumer.nextElement();
                if (!(data instanceof JASHist2DScatterData)) continue;
                JASHistScatterPlotStyle pstyle = (JASHistScatterPlotStyle)data.getStyle();
                pstyle.setDisplayAsScatterPlot(this.state);
            }
        }
    }
}

