/*
 * Decompiled with CFR 0.152.
 */
package jas.plot.java2;

import jas.plot.SetablePlotGraphics;
import jas.plot.Transformation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class PlotGraphics12
implements SetablePlotGraphics {
    private static final boolean[] isFilled = new boolean[]{true, true, true, true, false, false, false, false, false, false};
    private GeneralPath path = new GeneralPath();
    private Graphics2D g;
    private Line2D.Double line = new Line2D.Double();
    private Arc2D.Double arc = new Arc2D.Double();
    private Rectangle2D.Double rect = new Rectangle2D.Double();
    private RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private Shape oldClip;
    private Stroke oldStroke;
    private Transformation xt;
    private Transformation yt;
    private static final Transformation defaultTransformation = new Transformation(){

        public double convert(double value) {
            return value;
        }
    };

    public void setStroke(Stroke s) {
        if (s == null) {
            this.g.setStroke(this.oldStroke);
        } else {
            this.g.setStroke(s);
        }
    }

    public void setGraphics(Graphics gin) {
        this.g = (Graphics2D)gin;
        if (this.g == null) {
            this.oldClip = null;
            this.oldStroke = null;
        } else {
            this.oldClip = this.g.getClip();
            this.oldStroke = this.g.getStroke();
            this.g.setRenderingHints(this.rh);
        }
        this.clearTransformation();
    }

    public Graphics2D graphics() {
        return this.g;
    }

    public void setTransformation(Transformation x, Transformation y) {
        this.xt = x == null ? defaultTransformation : x;
        this.yt = y == null ? defaultTransformation : y;
    }

    public void clearTransformation() {
        this.xt = defaultTransformation;
        this.yt = defaultTransformation;
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.line.setLine(this.xt.convert(x1), this.yt.convert(y1), this.xt.convert(x2), this.yt.convert(y2));
        this.g.draw(this.line);
    }

    public void fillRect(double x1, double y1, double x2, double y2) {
        double h;
        double w;
        double t;
        double xx1 = this.xt.convert(x1);
        double yy1 = this.yt.convert(y1);
        double xx2 = this.xt.convert(x2);
        double yy2 = this.yt.convert(y2);
        if (xx2 < xx1) {
            t = xx1;
            xx1 = xx2;
            xx2 = t;
        }
        if (yy2 < yy1) {
            t = yy1;
            yy1 = yy2;
            yy2 = t;
        }
        if ((w = xx2 - xx1) < 1.0) {
            w = 1.0;
        }
        if ((h = yy2 - yy1) < 1.0) {
            h = 1.0;
        }
        this.rect.setRect(xx1, yy1, w, h);
        this.g.fill(this.rect);
    }

    public void drawOval(double x1, double y1, double x2, double y2) {
        double h;
        double w;
        double t;
        double xx1 = this.xt.convert(x1);
        double yy1 = this.yt.convert(y1);
        double xx2 = this.xt.convert(x2);
        double yy2 = this.yt.convert(y2);
        if (xx2 < xx1) {
            t = xx1;
            xx1 = xx2;
            xx2 = t;
        }
        if (yy2 < yy1) {
            t = yy1;
            yy1 = yy2;
            yy2 = t;
        }
        if ((w = xx2 - xx1) < 1.0) {
            w = 1.0;
        }
        if ((h = yy2 - yy1) < 1.0) {
            h = 1.0;
        }
        this.arc.setArc(xx1, yy1, w, h, 0.0, 360.0, 1);
        this.g.draw(this.arc);
    }

    public void drawRect(double x1, double y1, double x2, double y2) {
        double h;
        double w;
        double t;
        double xx1 = this.xt.convert(x1);
        double yy1 = this.yt.convert(y1);
        double xx2 = this.xt.convert(x2);
        double yy2 = this.yt.convert(y2);
        if (xx2 < xx1) {
            t = xx1;
            xx1 = xx2;
            xx2 = t;
        }
        if (yy2 < yy1) {
            t = yy1;
            yy1 = yy2;
            yy2 = t;
        }
        if ((w = xx2 - xx1) < 1.0) {
            w = 1.0;
        }
        if ((h = yy2 - yy1) < 1.0) {
            h = 1.0;
        }
        this.rect.setRect(xx1, yy1, w, h);
        this.g.draw(this.rect);
    }

    public void setColor(Color c) {
        this.g.setColor(c);
    }

    public void drawString(String s, double x, double y) {
        this.g.drawString(s, (float)this.xt.convert(x), (float)this.yt.convert(y));
    }

    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    public void drawSymbol(double x, double y, double size, int type) {
        Shape s = this.getShapeForSymbol(x, y, size, type);
        if (isFilled[type]) {
            this.g.fill(s);
        } else {
            this.g.draw(s);
        }
    }

    private Shape getShapeForSymbol(double x, double y, double size, int type) {
        float xx = (float)this.xt.convert(x);
        float yy = (float)this.yt.convert(y);
        float ss = (float)size / 2.0f;
        switch (type) {
            case 0: 
            case 8: {
                this.arc.setArc(xx - ss, yy - ss, size, size, 0.0, 360.0, 2);
                return this.arc;
            }
            case 1: 
            case 9: {
                this.rect.setRect(xx - ss, yy - ss, size, size);
                return this.rect;
            }
            case 2: {
                this.path.reset();
                this.path.moveTo(xx - ss, yy + ss);
                this.path.lineTo(xx + ss, yy + ss);
                this.path.lineTo(xx, yy - ss);
                this.path.closePath();
                return this.path;
            }
            case 3: {
                this.path.reset();
                this.path.moveTo(xx - ss, yy);
                this.path.lineTo(xx, yy + ss);
                this.path.lineTo(xx + ss, yy);
                this.path.lineTo(xx, yy - ss);
                this.path.closePath();
                return this.path;
            }
            case 4: {
                this.path.reset();
                this.path.moveTo(xx, yy + ss);
                this.path.lineTo(xx, yy - ss);
                this.path.moveTo(xx - ss, yy);
                this.path.lineTo(xx + ss, yy);
                this.path.moveTo(xx - ss, yy - ss);
                this.path.lineTo(xx + ss, yy + ss);
                this.path.moveTo(xx + ss, yy - ss);
                this.path.lineTo(xx - ss, yy + ss);
                return this.path;
            }
            case 5: {
                this.line.setLine(xx, yy + ss, xx, yy - ss);
                return this.line;
            }
            case 6: {
                this.line.setLine(xx - ss, yy, xx + ss, yy);
                return this.line;
            }
            case 7: {
                this.path.reset();
                this.path.moveTo(xx, yy + ss);
                this.path.lineTo(xx, yy - ss);
                this.path.moveTo(xx - ss, yy);
                this.path.lineTo(xx + ss, yy);
                return this.path;
            }
        }
        throw new RuntimeException("Unknown symbol " + type);
    }

    public void drawPolyLine(double[] x, double[] y, int n) {
        if (n <= 0) {
            return;
        }
        this.path.reset();
        this.path.moveTo((float)this.xt.convert(x[0]), (float)this.yt.convert(y[0]));
        for (int i = 1; i < n; ++i) {
            this.path.lineTo((float)this.xt.convert(x[i]), (float)this.yt.convert(y[i]));
        }
        this.g.draw(this.path);
    }

    public void setFont(Font f) {
        this.g.setFont(f);
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public void drawPolySymbol(double[] x, double[] y, double size, int type, int n) {
        for (int i = 0; i < n; ++i) {
            this.drawSymbol(x[i], y[i], size, type);
        }
    }

    public void drawImage(Image image, double x, double y, ImageObserver observer) {
        this.g.drawImage(image, (int)this.xt.convert(x), (int)this.yt.convert(y), observer);
    }

    public void drawImage(Image image, double x, double y, int width, int height, ImageObserver observer) {
        this.g.drawImage(image, (int)this.xt.convert(x), (int)this.yt.convert(y), width, height, observer);
    }

    public void setClip(int xmin, int xmax, int ymin, int ymax) {
        this.g.clipRect(xmin, ymax, xmax - xmin, ymin - ymax);
    }

    public void clearClip() {
        this.g.setClip(this.oldClip);
    }

    public Rectangle getClipBounds() {
        if (this.g == null) {
            return null;
        }
        return this.g.getClipBounds();
    }

    public BufferedImage createImage(int width, int height) {
        BufferedImage bi = null;
        bi = this.g != null ? this.g.getDeviceConfiguration().createCompatibleImage(width, height) : new BufferedImage(width, height, 2);
        return bi;
    }
}

