/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.title;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import org.jvnet.substance.SubstanceInternalFrameTitlePane;
import org.jvnet.substance.SubstanceInternalFrameUI;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceRootPaneUI;
import org.jvnet.substance.theme.ThemeChangeListener;
import org.jvnet.substance.title.TitleButtonInfo;
import org.jvnet.substance.utils.SubstanceTitlePane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TitleButtonManager {
    private Map<JRootPane, List<AbstractButton>> customTitlePaneButtons = new WeakHashMap<JRootPane, List<AbstractButton>>();
    private Map<JRootPane, List<TitleButton>> customTitlePaneButtonsExtra = new WeakHashMap<JRootPane, List<TitleButton>>();
    private Map<JRootPane, ThemeChangeListener> themeChangeListeners = new WeakHashMap<JRootPane, ThemeChangeListener>();
    private static TitleButtonManager instance;

    private TitleButtonManager() {
    }

    public static synchronized TitleButtonManager getManager() {
        if (instance == null) {
            instance = new TitleButtonManager();
        }
        return instance;
    }

    public synchronized List<TitleButton> addRootPaneCustomTitleButtons(final JRootPane rootPane, List<TitleButtonInfo> infoList, boolean addAtBeginning) {
        JComponent titlePane;
        ThemeChangeListener currThemeChangeListener = this.themeChangeListeners.get(rootPane);
        if (currThemeChangeListener != null) {
            SubstanceLookAndFeel.unregisterThemeChangeListener(currThemeChangeListener);
        }
        LinkedList<TitleButton> newButtonsExtra = new LinkedList<TitleButton>();
        LinkedList<AbstractButton> newButtons = new LinkedList<AbstractButton>();
        for (final TitleButtonInfo tButtonInfo : infoList) {
            final AbstractButton tButton = tButtonInfo.isToggle() ? new JToggleButton() : new JButton();
            tButton.setToolTipText(tButtonInfo.getTooltipText());
            tButton.addActionListener(tButtonInfo.getActionListener());
            tButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            tButton.setFocusable(false);
            tButton.setFocusPainted(false);
            tButton.setSelected(tButtonInfo.isSelected());
            final TitleButton titleButton = new TitleButton(tButton, tButtonInfo);
            newButtonsExtra.add(titleButton);
            newButtons.add(0, tButton);
            if (!tButtonInfo.isToggle()) continue;
            tButton.getModel().addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    tButtonInfo.setSelected(tButton.getModel().isSelected());
                    TitleButtonManager.this.updateButton(titleButton);
                }
            });
        }
        if (this.customTitlePaneButtons.get(rootPane) != null) {
            this.customTitlePaneButtons.get(rootPane).addAll(newButtons);
        } else {
            this.customTitlePaneButtons.put(rootPane, newButtons);
        }
        if (this.customTitlePaneButtonsExtra.get(rootPane) != null) {
            this.customTitlePaneButtonsExtra.get(rootPane).addAll(newButtonsExtra);
        } else {
            this.customTitlePaneButtonsExtra.put(rootPane, newButtonsExtra);
        }
        this.updateButtonIcons(rootPane);
        ThemeChangeListener newThemeChangeListener = new ThemeChangeListener(){

            public void themeChanged() {
                TitleButtonManager.this.updateButtonIcons(rootPane);
            }
        };
        this.themeChangeListeners.put(rootPane, newThemeChangeListener);
        SubstanceLookAndFeel.registerThemeChangeListener(newThemeChangeListener);
        if (rootPane.getParent() instanceof JInternalFrame) {
            SubstanceInternalFrameUI ifUi = (SubstanceInternalFrameUI)((JInternalFrame)rootPane.getParent()).getUI();
            titlePane = ifUi.getTitlePane();
            if (titlePane != null) {
                ((SubstanceInternalFrameTitlePane)titlePane).addCustomTitleButtons(newButtons, addAtBeginning);
                titlePane.doLayout();
                titlePane.repaint();
            }
        } else {
            SubstanceRootPaneUI rootPaneUi = (SubstanceRootPaneUI)rootPane.getUI();
            titlePane = (SubstanceTitlePane)rootPaneUi.getTitlePane();
            if (titlePane != null) {
                ((SubstanceTitlePane)titlePane).setCustomTitleButtons(newButtons);
                titlePane.doLayout();
                titlePane.repaint();
            }
        }
        LinkedList<TitleButton> result = new LinkedList<TitleButton>();
        for (TitleButton tb : newButtonsExtra) {
            result.add(tb);
        }
        return result;
    }

    public synchronized void removeRootPaneCustomTitleButtons(JRootPane rootPane) {
        ThemeChangeListener currThemeChangeListener = this.themeChangeListeners.remove(rootPane);
        if (currThemeChangeListener != null) {
            SubstanceLookAndFeel.unregisterThemeChangeListener(currThemeChangeListener);
        }
        this.themeChangeListeners.remove(rootPane);
        if (rootPane.getParent() instanceof JInternalFrame) {
            SubstanceInternalFrameUI ifUi = (SubstanceInternalFrameUI)((JInternalFrame)rootPane.getParent()).getUI();
            SubstanceInternalFrameTitlePane titlePane = ifUi.getTitlePane();
            if (titlePane != null) {
                Collection<AbstractButton> removed = titlePane.removeAllCustomTitleButtons();
                titlePane.doLayout();
                titlePane.repaint();
                for (AbstractButton b : removed) {
                    this.customTitlePaneButtons.get(rootPane).remove(b);
                }
                Iterator<TitleButton> it = this.customTitlePaneButtonsExtra.get(rootPane).iterator();
                while (it.hasNext()) {
                    TitleButton tb = it.next();
                    if (!removed.contains(tb.tButton)) continue;
                    it.remove();
                }
            }
        } else {
            this.customTitlePaneButtons.remove(rootPane);
            this.customTitlePaneButtonsExtra.remove(rootPane);
            SubstanceRootPaneUI rootPaneUi = (SubstanceRootPaneUI)rootPane.getUI();
            SubstanceTitlePane titlePane = (SubstanceTitlePane)rootPaneUi.getTitlePane();
            if (titlePane != null) {
                titlePane.setCustomTitleButtons(null);
                titlePane.doLayout();
                titlePane.repaint();
            }
        }
        this.cleanup(rootPane);
    }

    public synchronized void removeRootPaneCustomTitleButtons(JRootPane rootPane, List<TitleButton> buttonList) {
        SubstanceInternalFrameUI ifUi;
        SubstanceInternalFrameTitlePane titlePane;
        List<AbstractButton> titleButtons = this.customTitlePaneButtons.get(rootPane);
        List<TitleButton> titleButtonsExtra = this.customTitlePaneButtonsExtra.get(rootPane);
        LinkedList<AbstractButton> toRemove = new LinkedList<AbstractButton>();
        if (buttonList != null) {
            for (TitleButton tb : buttonList) {
                toRemove.add(tb.tButton);
                titleButtons.remove(tb.tButton);
                titleButtonsExtra.remove(tb);
            }
        }
        if (rootPane.getParent() instanceof JInternalFrame && (titlePane = (ifUi = (SubstanceInternalFrameUI)((JInternalFrame)rootPane.getParent()).getUI()).getTitlePane()) != null) {
            titlePane.removeCustomTitleButtons(toRemove);
            titlePane.doLayout();
            titlePane.repaint();
        }
        this.cleanup(rootPane);
    }

    private synchronized void cleanup(JRootPane rootPane) {
        ThemeChangeListener tcl;
        List<TitleButton> xtra;
        List<AbstractButton> btns = this.customTitlePaneButtons.get(rootPane);
        if (btns != null && btns.size() == 0) {
            this.customTitlePaneButtons.remove(rootPane);
        }
        if ((xtra = this.customTitlePaneButtonsExtra.get(rootPane)) != null && xtra.size() == 0) {
            this.customTitlePaneButtonsExtra.remove(rootPane);
        }
        if ((tcl = this.themeChangeListeners.get(rootPane)) != null) {
            SubstanceLookAndFeel.unregisterThemeChangeListener(tcl);
            this.themeChangeListeners.remove(rootPane);
        }
    }

    public void updateButton(TitleButton button) {
        Icon tIcon = button.tButtonInfo.getButtonCallback().getTitleButtonIcon(SubstanceLookAndFeel.getTheme(), 16, 16);
        if (tIcon.getIconWidth() > 16 || tIcon.getIconHeight() > 16) {
            throw new IllegalArgumentException("Title button callback returned image icon of illegal size");
        }
        button.tButton.setIcon(tIcon);
        button.tButton.setDisabledIcon(tIcon);
        button.tButton.setDisabledSelectedIcon(tIcon);
        button.tButton.setSelected(button.tButtonInfo.isSelected());
    }

    private void updateButtonIcons(JRootPane rootPane) {
        List<TitleButton> tButtons = this.customTitlePaneButtonsExtra.get(rootPane);
        if (tButtons == null) {
            return;
        }
        for (TitleButton tButton : tButtons) {
            this.updateButton(tButton);
        }
    }

    public List<AbstractButton> getCustomButtons(JRootPane rootPane) {
        return this.customTitlePaneButtons.get(rootPane);
    }

    public static class TitleButton {
        public AbstractButton tButton;
        public TitleButtonInfo tButtonInfo;

        public TitleButton(AbstractButton button, TitleButtonInfo buttonInfo) {
            this.tButton = button;
            this.tButtonInfo = buttonInfo;
        }
    }
}

