% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamac.R
\name{pssbounds}
\alias{pssbounds}
\title{Perform Pesaran, Shin and Smith (2001) cointegration test}
\usage{
pssbounds(data = list(), obs = NULL, fstat = NULL, tstat = NULL,
  case = NULL, k = NULL, digits = 3, object.out = FALSE)
}
\arguments{
\item{data}{an optional \code{\link{dynardl}} model. We highly recommend this option. Users are of course welcome to determine their own Case, t-statistic, F-statistic, and observations, but it is easier to have the model determine these quantities.}

\item{obs}{number of observations}

\item{fstat}{F-statistic of the joint test that variables in levels (except the lagged dependent variable) are equal to zero: \code{l.y = l.x1 + l.x2 +...+l.xk = 0}}

\item{tstat}{t-statistic of the lagged dependent variable}

\item{case}{specify certain restrictions on the constant and trend terms, since critical values differ by case. Case I: no intercept or trend, Case II: restricted intercept, no trend, Case III: unrestricted intercept with no trend, Case IV: unrestricted intercept and restricted trend, Case V: unrestricted intercept and trend. Case III is most frequently specified}

\item{k}{number of regressors appearing in levels in the estimated model}

\item{digits}{the number of digits to round to when showing output. We recommend three.}

\item{object.out}{if \code{TRUE}, and \code{dynardl.auto.correlated} is assigned to an object, the AIC, BIC, and results will be stored for the user's convenience.}
}
\description{
Perform Pesaran, Shin and Smith (2001) cointegration test
}
\details{
pssbounds performs post-estimation cointegration testing using the bounds testing procedure from Pesaran, Shin, and Smith (2001). Since test statistics vary based on the number of \code{k} regressors, length of the series, these are required, in addition to F- and t-statistics.
}
\examples{
# Using the ineq data from dynamac
# We can get all the values by hand
ardl.model <- dynardl(concern ~ incshare10 + urate, data = ineq, 
        lags = list("concern" = 1, "incshare10" = 1),
        diffs = c("incshare10", "urate"), 
        lagdiffs = list("concern" = 1),
       ec = TRUE, simulate = FALSE)
summary(ardl.model)
pssbounds(obs = 47, fstat = 7.01578, tstat = -3.223, case = 3, k = 1)

# Or just pass a dynardl model.
pssbounds(ardl.model)
}
\author{
Soren Jordan and Andrew Q. Philips
}
\keyword{cointegration}
