% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamac.R
\name{area.simulation.plot}
\alias{area.simulation.plot}
\title{Create an area plot of a simulated response in a dynardl model}
\usage{
area.simulation.plot(x, response = "levels", bw = FALSE)
}
\arguments{
\item{x}{a dynardl model with a simulation to be plotted}

\item{response}{whether the plot of the response should be shown in levels of the dependent variable (\code{levels}) 
or in changes from the mean of the dependent variable (\code{mean.changes}). The default is \code{levels}}

\item{bw}{should the colors be in black and white (for publication)? The default is \code{FALSE}}
}
\value{
an area plot
}
\description{
Create an area plot of a simulated response in a dynardl model
}
\details{
When running \code{dynardl}, \code{simulate} must be true so that there is a simulation to plot.
}
\examples{
# Using the ineq data in dynamac
# Shocking Income Top 10
ardl.model <- dynardl(concern ~ incshare10 + urate, data = ineq, 
       lags = list("concern" = 1, "incshare10" = 1),
       diffs = c("incshare10", "urate"), 
       lagdiffs = list("concern" = 1),
       ec = TRUE, simulate = TRUE, range = 30,
       shockvar = "incshare10")
area.simulation.plot(ardl.model)	# Shows absolute levels
area.simulation.plot(ardl.model, response = "mean.changes")  # Shows changes from mean level
area.simulation.plot(ardl.model, bw = TRUE)	 # Grayscale plots
}
\author{
Soren Jordan and Andrew Q. Philips
}
\keyword{utilities}
