% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_data_table.R
\name{as.data.table.dynamitefit}
\alias{as.data.table.dynamitefit}
\alias{as.data.table}
\title{Extract Samples From a \code{dynamitefit} Object as a Data Table}
\usage{
\method{as.data.table}{dynamitefit}(
  x,
  keep.rownames = FALSE,
  row.names = NULL,
  optional = FALSE,
  types = NULL,
  parameters = NULL,
  responses = NULL,
  times = NULL,
  groups = NULL,
  summary = FALSE,
  probs = c(0.05, 0.95),
  include_fixed = TRUE,
  ...
)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object.}

\item{keep.rownames}{[\code{logical(1)}]\cr Not used.}

\item{row.names}{Ignored.}

\item{optional}{Ignored.}

\item{types}{[\code{character()}]\cr Type(s) of the parameters for which the
samples should be extracted. See details of possible values. Default is
all values listed in details except spline coefficients \code{omega}.
This argument is mutually exclusive with \code{parameters}.}

\item{parameters}{[\code{character()}]\cr Parameter(s) for which the samples
should be extracted. Possible options can be found with function
\code{get_parameter_names()}. Default is all parameters of specific type for
all responses. This argument is mutually exclusive with \code{types}.}

\item{responses}{[\code{character()}]\cr Response(s) for which the samples
should be extracted. Possible options are elements of
\code{unique(x$priors$response)}, and the default is this entire vector.
Ignored if the argument \code{parameters} is supplied.
\code{omega_alpha}, and \code{omega_psi}. See also \code{\link[=get_parameter_types]{get_parameter_types()}}.}

\item{times}{[\code{double()}]\cr Time point(s) to keep. If \code{NULL}
(the default), all time points are kept.}

\item{groups}{[\code{character()}] Group name(s) to keep. If \code{NULL}
(the default), all groups are kept.}

\item{summary}{[\code{logical(1)}]\cr If \code{TRUE}, returns posterior
mean, standard deviation, and posterior quantiles (as defined by the
\code{probs} argument) for all parameters. If \code{FALSE} (default), returns the
posterior samples instead.}

\item{probs}{[\code{numeric()}]\cr Quantiles of interest. Default is
\code{c(0.05, 0.95)}.}

\item{include_fixed}{[\code{logical(1)}]\cr If \code{TRUE} (default), time-varying
parameters for \code{1:fixed} time points are included in the output as \code{NA}
values. If \code{FALSE}, fixed time points are omitted completely
from the output.}

\item{...}{Ignored.}
}
\value{
A \code{data.table} containing either samples or summary statistics of
the model parameters.
}
\description{
Provides a \code{data.table} representation of the posterior samples of the model
parameters. See \code{\link[=as.data.frame.dynamitefit]{as.data.frame.dynamitefit()}} for details.
}
\examples{
data.table::setDTthreads(1) # For CRAN
as.data.table(
  gaussian_example_fit,
  responses = "y",
  types = "beta",
  summary = FALSE
)

}
\seealso{
Model outputs
\code{\link{as.data.frame.dynamitefit}()},
\code{\link{as_draws_df.dynamitefit}()},
\code{\link{coef.dynamitefit}()},
\code{\link{confint.dynamitefit}()},
\code{\link{dynamite}()},
\code{\link{get_code}()},
\code{\link{get_data}()},
\code{\link{get_parameter_dims}()},
\code{\link{get_parameter_names}()},
\code{\link{get_parameter_types}()},
\code{\link{ndraws.dynamitefit}()},
\code{\link{nobs.dynamitefit}()}
}
\concept{output}
