% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_subset.R
\name{subset_parameter}
\alias{subset_parameter}
\title{Define a subset parameter}
\usage{
subset_parameter(id, default, values, description = NULL,
  tuneable = TRUE)
}
\arguments{
\item{id}{The name of the parameter.}

\item{default}{The default value of the parameter.}

\item{values}{A set of possible values.}

\item{description}{An optional (but recommended) description of the parameter.}

\item{tuneable}{Whether or not a parameter is tuneable.}
}
\description{
Define a subset parameter
}
\examples{
subset_parameter(
  id = "dimreds",
  default = c("pca", "mds"),
  values = c("pca", "mds", "tsne", "umap", "ica"),
  description = "Which dimensionality reduction methods to apply (can be multiple)"
)
}
\seealso{
\link{dynparam} for an overview of all dynparam functionality.
}
