% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapdf.R
\name{mapdf}
\alias{mapdf}
\alias{mapdf_lgl}
\alias{mapdf_chr}
\alias{mapdf_int}
\alias{mapdf_dbl}
\alias{mapdf_dfr}
\alias{mapdf_dfc}
\alias{mapdf_lat}
\alias{walkdf}
\title{Apply a function to each row of a data frame}
\usage{
mapdf(.x, .f, ...)

mapdf_lgl(.x, .f, ...)

mapdf_chr(.x, .f, ...)

mapdf_int(.x, .f, ...)

mapdf_dbl(.x, .f, ...)

mapdf_dfr(.x, .f, ...)

mapdf_dfc(.x, .f, ...)

mapdf_lat(.x, .f, ...)

walkdf(.x, .f, ...)
}
\arguments{
\item{.x}{A data.frame, data_frame, or tibble.}

\item{.f}{A function or formula.
If a function, the first argument will be the row as a list.
If a formula, e.g. \code{~ .$a}, the \code{.} is a placeholder for the row as a list.}

\item{...}{Additional arguments passed on to \code{.f}.}
}
\description{
The mapdf functions transform their input by applying a function to each row of a data frame and returning a vector the same length as the input.
These functions work a lot like purrr's \code{\link[purrr]{map}} functions.
}
\details{
* \code{mapdf()} always returns a list.

* \code{mapdf_lgl()}, \code{mapdf_int()}, \code{mapdf_dbl()} and \code{mapdf_chr()} return vectors of the corresponding type (or die trying).

* \code{mapdf_dfr()} and \code{mapdf_dfc()} return data frames created by row-binding and column-binding respectively. They require dplyr to be installed.

* \code{mapdf_lat()} returns a tibble by transforming outputted lists to a tibble using \code{\link{list_as_tibble}}.

* \code{walkdf()} calls .f for its side-effect and returns the input .x.
}
\examples{
library(dplyr)

tib <- tibble(
  a = c(1, 2),
  b = list(log10, sqrt),
  c = c("parrot", "quest"),
  .object_class = list(c("myobject", "list"), c("yourobject", "list"))
)

# map over the rows using a function
tib \%>\% mapdf(class)

# or use an anonymous function
tib \%>\% mapdf(function(row) paste0(row$b(row$a), "_", row$c))

# or a formula
tib \%>\% mapdf(~ .$b)

# there are many more variations available
# see ?mapdf for more info
tib \%>\% mapdf_lgl(~ .$a > 1)
tib \%>\% mapdf_chr(~ paste0("~", .$c, "~"))
tib \%>\% mapdf_int(~ nchar(.$c))
tib \%>\% mapdf_dbl(~ .$a * 1.234)
}
