% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_linear_trajectory.R
\name{add_linear_trajectory}
\alias{add_linear_trajectory}
\title{Constructs a linear trajectory using pseudotime values}
\usage{
add_linear_trajectory(
  dataset,
  pseudotime,
  directed = FALSE,
  do_scale_minmax = TRUE,
  ...
)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{pseudotime}{A named vector of pseudo times.}

\item{directed}{Whether the trajectory will be directed.}

\item{do_scale_minmax}{Whether or not to scale the pseudotime between 0 and 1.
Otherwise, will assume the values are already within that range.}

\item{...}{extra information to be stored in the trajectory}
}
\value{
The dataset object with trajectory information, including:
\itemize{
\item \emph{milestone_ids}: The names of the milestones, a character vector.
\item \emph{milestone_network}: The network between the milestones, a dataframe with the \emph{from} milestone, \emph{to} milestone, \emph{length} of the edge, and whether it is \emph{directed}.
\item \emph{divergence_regions}: The regions between three or more milestones where cells are diverging, a dataframe with the divergence id (\emph{divergence_id}), the milestone id (\emph{milestone_id}) and whether this milestone is the start of the divergence (\emph{is_start})
\item \emph{milestone_percentages}: For each cell its closeness to a particular milestone, a dataframe with the cell id (\emph{cell_id}), the milestone id (\emph{milestone_id}), and its \emph{percentage} (a number between 0 and 1 where higher values indicate that a cell is close to the milestone).
\item \emph{progressions}: For each cell its progression along a particular edge of the \emph{milestone_network}. Contains the same information as \emph{milestone_percentages}. A dataframe with cell id (\emph{cell_id}), \emph{from} milestone, \emph{to} milestone, and its \emph{percentage} (a number between 0 and 1 where higher values indicate that a cell is close to the \emph{to} milestone and far from the \emph{from} milestone).
}
}
\description{
Constructs a linear trajectory using pseudotime values
}
\examples{
library(tibble)
dataset <- wrap_data(cell_ids = letters)

pseudotime <- tibble(
  cell_id = dataset$cell_ids,
  pseudotime = runif(length(dataset$cell_ids))
)

trajectory <- add_linear_trajectory(dataset, pseudotime)
}
\keyword{create_trajectory}
