% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_milestone_network.R
\name{classify_milestone_network}
\alias{classify_milestone_network}
\title{Classify a milestone network}
\usage{
classify_milestone_network(milestone_network)
}
\arguments{
\item{milestone_network}{A milestone network}
}
\value{
A list containing
\itemize{
\item \emph{network_type}: The network type (also known as the trajectory_type). See \code{dynwrap::trajectory_types} for an overview.
\item \emph{directed}: Whether the trajectory is directed
\item \emph{properties}: Different properties of the trajectory, including:
\itemize{
\item \emph{is_directed}: Whether the trajectory is directed
\item \emph{max_degree}: The maximal degree
\item \emph{num_branch_nodes}: The number of branching nodes
\item \emph{num_outer_nodes}: Number of leaf (outer) nodes
\item \emph{is_self_loop}: Whether it contains self-loops
\item \emph{has_cycles}: Whether it has cycles
\item \emph{num_components}: The number of independent components
}
}
}
\description{
Classify a milestone network
}
\examples{
milestone_network <- tibble::tibble(
  from = c("A", "B", "C"),
  to = c("B", "C", "A"),
  length = 1,
  directed = TRUE
)
classification <- classify_milestone_network(milestone_network)
classification$network_type
classification$directed

milestone_network <- tibble::tibble(
  from = c("A", "B", "B", "C", "C"),
  to = c("B", "C", "D", "E", "F"),
  length = 2,
  directed = FALSE
)
classification <- classify_milestone_network(milestone_network)
classification$network_type
classification$directed
classification$props

}
\seealso{
\code{dynwrap::trajectory_types}
}
