% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eLNNpaired.r
\name{eLNNpaired}
\alias{eLNNpaired}
\title{Detecting Differentially Expressed Gene Probes via eLNNpaired Model}
\description{
Detecting differentially expressed gene probes via eLNNpaired model.
}
\usage{
eLNNpaired(
  E_Set, 
  b = c(2, 2, 2), 
  verbose = 0,
  converge_threshold = 1e-06, 
  using_limit = 0,
  param_limit_min = c(-6, qnorm(0.01), -6, -6, -6, qnorm(0.01), -6, -6, -6, -6), 
  param_limit_max = c(6, qnorm(0.99), 6, 6, 6, qnorm(0.99), 6, 6, 6, 6), 
  maxIT = 100,  
  maxRT = 100, 
  c1 = qnorm(0.95), 
  c2 = qnorm(0.05))
}
\arguments{
\item{E_Set}{An ExpressionSet object containing within-subject log2 difference of gene expression levels.}

\item{b}{A vector of concentration parameters used in Dirichlet distribution. Default value is \code{b = c(2,2,2)}.}

\item{verbose}{An indicator variable telling if print out intermediate results: zero value for not printing out, non-zero for printing out. Default value is \code{verbose = 0}.}

\item{converge_threshold}{One of the two termination criteria of iteration. The smaller this value is set, the harder the optimization procedure in eLNNpaired will be considered to be converged. Default value is \code{converge_threshold = 1e-6}.}

\item{using_limit}{An indicator variable telling if constrained optimization method will be adopted: zero value for unconstrained while non-zero value for constrained optimization. Default value is \code{using_limit = 0}. Note that even if \code{using_limit} 
is set to be 0, the following two parameters 
\code{param_limit_min} and \code{param_limit_max} may still be used when initial estimation of one or more of the parameters are not feasible.}

\item{param_limit_min}{An vector of lower bounds of parameters. 
Default value is \code{param_limit_min = c(-6,qnorm(0.01),-6,-6,-6,qnorm(0.01),-6,-6,-6,-6)}.}

\item{param_limit_max}{An vector of upper bounds of parameters. Default value is \code{param_limit_max = c(6,qnorm(0.99),6,6,6,qnorm(0.99),6,6,6,6) = -param_limit_min}.}

\item{maxIT}{An integer, the max allowed number of iterations in R built-in function optim. Default value is maxIT = 100.}

\item{maxRT}{An integer, the max allowed number of iterations for EM algorithm. Default value is \code{maxRT = 100}.}

\item{c1}{A parameter in constraints. It should be in the form of 
\code{c1 = qnorm(X)}, where \code{X} is a decimal smaller than 1 but close to 1. 
Larger X gives more stringent constraint. Default value is \code{c1 = qnorm(0.95)}.}

\item{c2}{A parameter in constraints. It should be in the form of 
\code{c2 = qnorm(Y)}, where Y is a decimal larger than 0 but close to 0. 
Smaller Y gives more stringent constraint. Default value is 
\code{c2 = qnorm(0.05)}.}
}
\value{
A list of 8 elementes: 
\item{mleinfo}{the return value from built-in optim function}

\item{psi}{estimated reparameterized parameters}

\item{para.orig}{estimated parameters in original scale}

\item{memGenes}{3-cluster probe cluster membership: 1 indicates over-expressed
probes; 2 indicates under-expressed probes; 3 indicates 
non-differentially expressed probes}

\item{memGenes2}{2-clustre probe cluster membership: 1 indicates differentially-expressed
probes; 0 indicates non-differentially expressed probes}

\item{t_pi}{the cluster proportion for cluster 1 (over-expressed probes)
and cluster 2 (under-expressed probes).}

\item{repeated_times}{the number of iterations that EM algorithm takes} 

\item{tilde_z}{tilde z as discribed in paper, 
  the posterior probability that each gene will fall into each cluster.}

}
\author{
Yunfeng Li <colinlee1999@gmail.com> and Weiliang Qiu <stwxq@channing.harvard.edu>
}
\examples{
set.seed(100)
G = 500
n = 10

delta_1 = -0.8184384  
xi_1 = -1.1858546 
lambda_1 = -10.6309216  
nu_1 = -3.5536255  

delta_2 = -0.8153614  
xi_2 = -1.4120148 
lambda_2 = -13.1999427  
nu_2 = -3.3873531   

lambda_3 = 0.7597441  
nu_3 = -2.0361091 

psi = c(delta_1, xi_1, lambda_1, nu_1,
        delta_2, xi_2, lambda_2, nu_2,
        lambda_3, nu_3)
t_pi = c(0.08592752, 0.07110449)

c1 = qnorm(0.95)
c2 = qnorm(0.05)

E_Set = gen_eLNNpaired(G, n, psi, t_pi, c1, c2)


result = eLNNpaired(E_Set, verbose = 1, c1 = c1, c2 = c2)

print(table(result$memGenes, fData(E_Set)$memGenes.true))
print(table(result$memGenes2, fData(E_Set)$memGenes2.true))

}
\keyword{ method }% use one of  RShowDoc("KEYWORDS")
\references{Li Y, Morrow J, Raby B, Tantisira K, Weiss ST, Huang W, Qiu W. (2017), <doi:10.1371/journal.pone.0174602>}
