% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyPubMed_scr.R
\name{fetch_all_pubmed_ids}
\alias{fetch_all_pubmed_ids}
\title{Retrieve All PubMed Record Identifiers Returned by a Query}
\usage{
fetch_all_pubmed_ids(pubmed_id_list)
}
\arguments{
\item{pubmed_id_list}{List: the result of a get_pubmed_ids() call.}
}
\value{
Character vector including all PMID (PubMed Identifiers) returned by the current query.
}
\description{
Retrieve PubMed record identifiers from Entrez following a search performed 
via the get_pubmed_ids() function. Identifiers are returned as a character vector.
}
\details{
Retrieve PubMed identifiers, without any other information (such as article title, 
authors, publication date, and so on). The PubMed IDs can be stored or used with other software.
}
\examples{
\dontrun{
## Fetch only PubMed Record IDs (PMIDs)
dami_query_string <- "Damiano Fantini[AU]"
dami_on_pubmed <- get_pubmed_ids(dami_query_string)
dami_pmids <- fetch_all_pubmed_ids(dami_on_pubmed)
print(dami_pmids)

}

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini \email{damiano.fantini@gmail.com}
}
