% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProtectTable.R
\encoding{UTF8}
\name{ProtectTable}
\alias{ProtectTable}
\title{Easy interface to sdcTable: Table suppression according to a frequency rule.}
\usage{
ProtectTable(data, dimVar = 1:NCOL(data), freqVar = NULL,
  protectZeros = TRUE, maxN = 3, method = "SIMPLEHEURISTIC",
  findLinked = TRUE, total = "Total", addName = FALSE, sep = "_",
  removeZeros = FALSE, groupVarInd = NULL, ind1 = NULL, ind2 = NULL,
  rowData = NULL, varNames = paste("var", 1:100, sep = ""), split = NULL,
  border = sep, revBorder = FALSE, freqName = "values",
  totalFirst = FALSE, numericOrder = TRUE, namesAsInput = TRUE,
  orderAsInput = TRUE, sortByReversedColumns = FALSE, doUnstack = TRUE,
  removeTotal = TRUE, singleOutput = NULL, suppression = NA,
  outFreq = "freq", outSdcStatus = "sdcStatus",
  outSuppressed = "suppressed", ...)
}
\arguments{
\item{data}{data frame}

\item{dimVar}{The main dimensional variables and additional aggregating variables (name or number).}

\item{freqVar}{Variable(s) holding counts or NULL in the case of micro data (name or number).}

\item{protectZeros}{When TRUE empty cells (count=0) is considered sensitive (i.e. same as allowZeros in  \code{\link{primarySuppression}}).}

\item{maxN}{All cells having counts <= maxN are set as primary suppressed.}

\item{method}{Parameter "method" in \code{\link{protectTable}} or \code{\link{protectLinkedTables}}.
Default is "SIMPLEHEURISTIC". Other allowed values are
"OPT", "HITAS" and "HYPERCUBE". The latter is not possible in cases with two linked tables.}

\item{findLinked}{When TRUE, the function may find two linked tables and run protectLinkedTables.}

\item{total}{String used to name totals.}

\item{addName}{When TRUE the variable name is added to the level names, except for variables with most levels.}

\item{sep}{A character string to separate when addName apply and when creating variable names.}

\item{removeZeros}{When TRUE, rows with zero count will be removed from the data within the algorithm.}

\item{groupVarInd}{Possible manual specification of list defining the hierarchical 
variable groups. When NULL (default) this information will be found automatically 
by \code{\link{FindTableGroup}}.}

\item{ind1}{Coding of table 1 as indices referring to elements of groupVarInd. This information 
will be found automatically 
by \code{\link{FindTableGroup}} when groupVarInd=NULL.}

\item{ind2}{Coding of table 2 as indices referring to elements of groupVarInd (as ind1 above).}

\item{rowData}{Input to \code{\link{Stack}} used to generate extra dimVar variables when stacking in cases with several 
freqvar variables. When NULL rowData will be created automatically by \code{\link{AutoSplit}} using varNames (see below)
and the the freqvar names as input.}

\item{varNames}{The names of the extra dimVar variable(s) made when stacking in cases with several 
freqvar variables. When length(varNames)>1 several variables may be found by \code{\link{AutoSplit}}.}

\item{split}{Parameter to \code{\link{AutoSplit}} - see varNames and rowData above.
When NULL (default), automatic splitting without needing a split string.}

\item{border}{Parameter to \code{\link{AutoSplit}} - see varNames and rowData above.}

\item{revBorder}{Parameter to \code{\link{AutoSplit}} - see varNames and rowData above..}

\item{freqName}{Input to \code{\link{Stack}}. The name of the new freqvar variable obtained when stacking in cases with several 
input freqvar variables.}

\item{totalFirst}{Parameter controlling how output is sorted.}

\item{numericOrder}{Parameter controlling how output is sorted. 
Output is character but sorting can be based on the numeric input variables.}

\item{namesAsInput}{When TRUE those output variables (created by unstacking) that correspond to input will be named as input.}

\item{orderAsInput}{When TRUE output corresponding to input will be ordered as input and kept together as one block.}

\item{sortByReversedColumns}{When TRUE output will be sorted by variables in opposite order.}

\item{doUnstack}{When FALSE output will not be unstacked (in cases with sever input freqvar variables)}

\item{removeTotal}{When TRUE the total string (see total above) will be removed from the names of output variables 
created by unstacking (in cases with sever input freqvar variables).}

\item{singleOutput}{When TRUE output will be in as single data set. Default is FALSE for unstacked data
(in cases with sever input freqvar variables) and otherwise TRUE.}

\item{suppression}{Value used for suppressed elements in suppressed output data. Default is NA.}

\item{outFreq}{String used to name output variable(s)}

\item{outSdcStatus}{String used to name output variable(s)}

\item{outSuppressed}{String used to name output variable(s)}

\item{...}{Further parameters sent to \code{\link{protectTable}} (possibly via \code{\link{protectLinkedTables}})
such as verbose (print output while calculating) and timeLimit.}
}
\value{
When singleOutput=TRUE output is a list of two elements.

        \item{info}{Information as a single column character matrix. This is information about the extra 
                    dimVar variables created when stacking, information about the identified (linked) 
                    table(s) and summary output from sdcTable.}
        \item{data}{A data frame where variables are named according to outFreq, 
                    outSdcStatus and outSuppressed.}
        When singleOutput=FALSE output element data is replaced by three elements and these are named  
        according to outFreq, outSdcStatus and outSuppressed.
}
\description{
protectTable or protectLinkedTables is run with a data set as the only required input.
 One (stacked) or several (unstacked) input variables can hold cell counts.
 Output is on a form similar to input.
}
\details{
One or two tables are identified automatically and subjected to cell suppression 
         by \code{\link{protectTable}} (single table) or \code{\link{protectLinkedTables}} (two linked tables).
         The tables can alternatively be specified manually by groupVarInd, ind1 and ind2.
         The output will be on a form similiar to input depending on whether freqVar is a single variable or not.
         The status of the cells are 
         coded as  "u" (primary suppressed), "x" (secondary suppression), and "s" (can be published).
         This is taken directly from the output from sdcTable. In cases with two linked tables "u" or "x" 
         for common cells are based on output from the first table.
         
         NOTE: The use of numVarInd, weightInd and sampWeightInd in sdcTable is not implemented.
}
\examples{
 # ==== Example 1 , 8 regions ====
 z1 <- EasyData("z1")        
 ProtectTable(z1,1:2,3)
 ProtectTable(z1,c("region","hovedint") ,"ant") # Input by name 
 # --- Unstacked input data ---
 z1w = EasyData("z1w") 
 ProtectTable(z1w,1,2:5)
 ProtectTable(z1w,1,2:5,varName="hovedint") 
 ProtectTable(z1w,1,2:5,method="HITAS")
 ProtectTable(z1w,1,2:5,totalFirst = TRUE)
 
 # ==== Example 2 , 11 regions ====
 z2 <- EasyData("z2") 
 ProtectTable(z2,c(1,3,4),5) # With region-variable kostragr
 # --- Unstacked input data ---
 z2w <- EasyData("z2w") 
 ProtectTable(z2w,1:2,4:7) # With region-variable fylke
 ProtectTable(z2w,1:3,4:7) # Two linked tables
 
 \dontrun{
 # ==== Example 3 , 36 regions ====
 z3 <- EasyData("z3")   
 ProtectTable(z3,c(1,4,5),7) # Three dimensions. No subtotals    
 ProtectTable(z3,1:6,7)      # Two linked tables  
 # --- Unstacked input data with coded column names 
 z3w <- EasyData("z3w")
 ProtectTable(z3w,1:3,4:15,varName="g12") # coding not used when single varName
 ProtectTable(z3w,1:3,4:15,varName=c("hovedint","mnd"))  # Two variables found automatically 
 ProtectTable(z3w,1:3,4:15,varName=c("hovedint","mnd"),
               removeTotal=FALSE) # Keep "Total" in variable names 
 # --- Unstacked input data with three level column name coding  
 ProtectTable(z3wb,1:3,4:15,varName=c("hovedint","mnd","mnd2")) # Two variables found automatically
 ProtectTable(z3wb,1:3,4:15,varName=c("hovedint","mnd","mnd2"), 
               split="_")  # Three variables when splitting
 ProtectTable(z3wb,1:3,4:15,varName=c("hovedint","mnd","mnd2"), 
               split="_",namesAsInput=FALSE,orderAsInput=FALSE) # Alternative ouput format
               }
}
\seealso{
protectTable makes a call to the function \code{\link{ProtectTable1}}.
}

