% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PtGui.R
\encoding{UTF8}
\name{PTgui}
\alias{PTgui}
\alias{PTguiNO}
\title{Table suppression - Shiny Gui}
\usage{
PTgui(data = NULL, language = "English", exeArgus = NULL,
  pathArgus = getwd(), maxNchoices = c(1:10, 12, 15, 20), ...)

PTguiNO(data = NULL, language = "Norwegian", exeArgus = NULL,
  pathArgus = getwd(), maxNchoices = c(1:10, 12, 15, 20), ...)
}
\arguments{
\item{data}{NULL or a data.frame}

\item{language}{Menu language, "English" or "Norwegian".}

\item{exeArgus}{Tau-argus executable}

\item{pathArgus}{Folder for (temporary) tau-argus files}

\item{maxNchoices}{Choices of maxN}

\item{...}{Further parameters sent to ProtectTable}
}
\value{
Output from \code{\link{ProtectTable}}. The output is returned invisibly 
 (via \code{\link{invisible}}) which means that it is not automatically printed to the console.
}
\description{
Table suppression - Shiny Gui
}
\examples{
  \dontrun{
  
# Start the gui.
PTgui()

# Start Norwegian gui with example data and catch output
out <- PTguiNO(data=EasyData("z1w"))   

# Tau-argus executable 
exeArgus <- "C:/TauArgus4.1.4/TauArgus.exe"

# Folder for (temporary) tau-argus files
pathArgus <- "C:/Users/nnn/Documents"
    
# Start the gui with possibility to run tau-argus.       
PTgui(exeArgus=exeArgus, pathArgus=pathArgus)     
  
  }


}
