% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_marginal_hist.R
\name{add_marginal_histograms}
\alias{add_marginal_histograms}
\title{add marginal histograms to alluvial plot}
\usage{
add_marginal_histograms(
  p,
  data_input,
  top = TRUE,
  keep_labels = FALSE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{p}{alluvial plot}

\item{data_input}{dataframe, input data that was used to create dataframe}

\item{top}{logical, position of histograms, if FALSE adds them at the bottom,
Default: TRUE}

\item{keep_labels}{logical, keep title and caption, Default: FALSE}

\item{plot}{logical if plot should be drawn or not}

\item{...}{additional arguments for model response alluvial plot concerning
the response variable \describe{ \item{pred_train}{display training
prediction, not necessary if pred_train has already been passed to
alluvial_model_response()} \item{scale}{int, y-axis distance between the
ridge plots, Default: 400 } \item{pred_var}{character vector, specify
response variable in data_input, if not set response variable will try to be
inferred, Default: NULL } }}
}
\value{
gtable
}
\description{
will add density histograms and frequency plots of original data
 to alluvial plot
}
\examples{
p = alluvial_wide(mtcars2, max_variables = 4)
p_grid = add_marginal_histograms(p, mtcars2)
}
\seealso{
\code{\link[gridExtra]{arrangeGrob}}
}
