% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspectSolution.R
\name{inspectSolution}
\alias{inspectSolution}
\title{Inspect a \code{useSolver} output}
\usage{
inspectSolution(
  solverOut,
  items,
  idCol,
  colNames = names(items),
  colSums = TRUE
)
}
\arguments{
\item{solverOut}{Object created by \code{useSolver} function.}

\item{items}{Original \code{data.frame} containing information on item level.}

\item{idCol}{Column name in \code{items} containing item IDs. These will be used for matching to the solver output.}

\item{colNames}{Which columns should be used from the \code{items} \code{data.frame}?}

\item{colSums}{Should column sums be calculated in the output? Only works if all columns are numeric.}
}
\value{
A \code{list} with assembled blocks as entries. Rows are the individual items. A final row is added, containing
the sums of each column.
}
\description{
Process a \code{useSolver} output of a successfully solved optimization problem to a list so it becomes humanly readable.
}
\details{
This function merges the initial item pool information in \code{items} to the solver output in \code{solverOut}.
Relevant columns can be selected via \code{colNames}. Column sums within test forms are calculated if possible and
if \code{colSum} is set to \code{TRUE}.
}
\examples{
## Example item pool
items <- data.frame(ID = 1:10,
itemValues = c(-4, -4, -2, -2, -1, -1, 20, 20, 0, 0))

## Test Assembly
usage <- itemUsageConstraint(nForms = 2, operator = "=",
                             targetValue = 1, itemIDs = items$ID)
perForm <- itemsPerFormConstraint(nForms = 2, operator = "=",
                                  targetValue = 5, itemIDs = items$ID)
target <- minimaxConstraint(nForms = 2,
                               itemValues = items$itemValues,
                               targetValue = 0, itemIDs = items$ID)
sol <- useSolver(allConstraints = list(usage, perForm, target),
                                  solver = "lpSolve")

## Inspect Solution
out <- inspectSolution(sol, items = items, idCol = 1, colNames = "itemValues")

}
