% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertCase.R
\name{convertCase}
\alias{convertCase}
\alias{convertCase.GADSdat}
\title{Modify upper and lower case for strings.}
\usage{
convertCase(x, case = c("lower", "upper", "upperFirst"), ...)

\method{convertCase}{GADSdat}(x, case = c("lower", "upper", "upperFirst"), vars, ...)
}
\arguments{
\item{x}{A character vector, \code{data.frame}, or \code{GADSdat}.}

\item{case}{Character vector of length 1. What case should the strings be converted to? Available options are
\code{"lower"}, \code{"upper"}, or \code{"upperFirst"}.}

\item{...}{further arguments passed to or from other methods.}

\item{vars}{Character vector. What variables in the \code{GADSdat} should the conversion be applied to?}
}
\value{
Returns the converted object.
}
\description{
Convert a character vector, all character variables in a \code{data.frame} or selected variables in a \code{GADSdat} to
upper (\code{"uppper"}), lower (\code{"lower"}), or first letter upper and everything else lower case (\code{"upperFirst"}).
}
\section{Methods (by class)}{
\itemize{
\item \code{convertCase(GADSdat)}: convert case for \code{GADSdats}

}}
\examples{
# for character
convertCase(c("Hi", "HEllo", "greaT"), case = "upperFirst")

# for GADSdat
input_g <- import_DF(data.frame(v1 = 1:3, v2 = c("Hi", "HEllo", "greaT"),
                          stringsAsFactors = FALSE))
convertCase(input_g, case = "upperFirst", vars = "v2")


}
