% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ebirdst_runs}
\alias{ebirdst_runs}
\title{Data frame of available eBird Status and Trends species}
\format{
A data frame with 15 variables:
\describe{
\item{run_name}{Unique analysis identifier and the top level folder name
for all results}
\item{species_code}{Six letter eBird code in eBird Taxonomy v2018}
\item{scientific_name}{Scientific name from eBird Taxonomy v2018}
\item{common_name}{English common name from eBird Taxonomy v2018}
\item{resident}{Classifies this species a resident or a migrant}
\item{breeding_quality}{Breeding season quality}
\item{breeding_range_modeled}{Is the full range modeled?}
\item{breeding_start}{Breeding season start date}
\item{breeding_end}{Breeding season start date}
\item{nonbreeding_quality}{Non-breeding season quality}
\item{nonbreeding_range_modeled}{Is the full range modeled?}
\item{nonbreeding_start}{Non-breeding season start date}
\item{nonbreeding_end}{Non-breeding season start date}
\item{postbreeding_migration_quality}{Post-breeding season quality}
\item{postbreeding_migration_range_modeled}{Is the full range modeled?}
\item{postbreeding_migration_start}{Post-breeding season start date}
\item{postbreeding_migration_end}{Post-breeding season start date}
\item{prebreeding_migration_quality}{Pre-breeding season quality}
\item{prebreeding_migration_range_modeled}{Is the full range modeled?}
\item{prebreeding_migration_start}{Pre-breeding season start date}
\item{prebreeding_migration_end}{Pre-breeding season start date}
\item{resident_quality}{Resident quality}
\item{resident_start}{For resident species, the year-round start date}
\item{resident_end}{For resident species, the year-round end date}
}
}
\usage{
ebirdst_runs
}
\description{
A dataset containing the species for which eBird Status and Trends data are
available In addition, the dates defining the boundaries of the seasons are
provided. These seasons are defined on a species-specific basis through
expert review. For information on the details of defining seasons, please see
the \href{https://ebird.org/science/status-and-trends/faq#seasons}{seasons section of the FAQ}. Note that
missing dates imply that a season failed expert review for that species
within that season.
}
\keyword{datasets}
