% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_and_leave_one_out.R
\name{loo_ebmstate}
\alias{loo_ebmstate}
\title{Leave-one-out estimation}
\usage{
loo_ebmstate(
  mstate_data,
  mstate_data_expanded,
  which_group,
  patient_IDs,
  initial_state,
  tmat,
  time_model,
  backup_file = NULL,
  input_file = NULL,
  coxrfx_args = list(),
  msfit_args = NULL,
  probtrans_args = NULL
)
}
\arguments{
\item{mstate_data}{Data in `long format`.}

\item{mstate_data_expanded}{Data in `long format`, possibly with `expanded` covariates (as obtained by running mstate::expand.covs).}

\item{which_group}{A character vector with the same meaning as the `groups` argument of the function \code{CoxRFX} but named (with the covariate names).}

\item{patient_IDs}{The IDs of the patients whose cumulative hazards and transition probabilities one wishes to estimate.}

\item{initial_state}{The initial state for which transition probability estimates should be computed}

\item{tmat}{Transition matrix for the multi-state model, as obtained by running \code{mstate::transMat}}

\item{time_model}{The model of time-dependency: either 'Markov' or 'semiMarkov'.}

\item{backup_file}{Path to file. Objects generated while the present function is running are stored in this file. 
This avoids losing all estimates if and when the algorithm breaks down. See argument \code{input_file}.}

\item{input_file}{Path to \code{backup_file} (see argument \code{backup_file}). If this argument is given, all other arguments should be \code{NULL}.}

\item{coxrfx_args}{Named list with arguments to the \code{CoxRFX} function other than \code{Z},\code{surv} and \code{groups}.}

\item{msfit_args}{Named list with arguments to the \code{msfit_generic.coxrfx} function other than \code{object},\code{newdata} and \code{trans}.}

\item{probtrans_args}{Named list with arguments to the \code{probtrans_ebmstate} function other than \code{initia_state},\code{cumhaz} and \code{model}.}
}
\value{
A list with: 95\% bootstrap intervals for each regression coefficient and for transition probabilities; 
bootstrap samples of regression coefficients, cumulative hazards and transition probabilities.
}
\description{
This function computes leave-one-out estimation of regression coefficients,
cumulative hazard functions, and transition probability functions.
}
\details{
In a given bootstrap sample there might not be enough information to generate 
estimates for all coefficients. If a covariate has little or no variation in a given bootstrap sample, 
no estimate of its coefficient will be computed. The present function will
keep taking bootstrap samples until every coefficient has been estimated
at least \code{min_nr_samples} times.
}
\author{
Rui Costa
}
