% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdattr-constructor.R
\name{ecdattr}
\alias{ecdattr}
\title{Constructor of \code{ecdattr} class for the Elliptic Database (ECDB)}
\usage{
ecdattr(alpha, gamma = NaN, cusp = 0, use.mpfr = FALSE)
}
\arguments{
\item{alpha}{numeric, must be an integer after multiplied by 1000000.}

\item{gamma}{numeric, must be an integer after multiplied by 1000000.
\code{NaN} if cusp is 1.}

\item{cusp}{numeric, representing type of cusp. Only 0 (default) and 1 are allowed.}

\item{use.mpfr}{logical, whether to use mpfr for ecd object, default is \code{FALSE}.}
}
\value{
an object of \code{ecdattr} class
}
\description{
Construct an \code{ecdattr} class by providing the required parameters.
This object has one-to-one correspondence to the rows in \code{ECDATTR} table.
This is used primarily as object wrapper for safe update to ECDB.
}
\examples{
a <- ecdattr(1,1)
b <- ecdattr(alpha=1, cusp=1)

}
\keyword{constructor}
\keyword{ecdattr}

