% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-op-V-method.R
\name{ecld.op_V}
\alias{ecld.op_O}
\alias{ecld.op_U_lag}
\alias{ecld.op_V}
\title{The O, V, U operators in option pricing model}
\usage{
ecld.op_V(L, k, otype = "c", stop.on.na = FALSE, use.mc = TRUE)

ecld.op_O(sigma1, k, otype = "c")

ecld.op_U_lag(L, k, sd, n = 2)
}
\arguments{
\item{L}{a vector of option state prices}

\item{k}{a numeric vector of log-strike}

\item{otype}{character, specifying option type:
\code{c} (default) or \code{p}.}

\item{stop.on.na}{logical, to stop if fails to find solution.
Default is to use NaN and not stop.}

\item{use.mc}{logical, to use mclapply (default), or else just use for loop.
For loop option is typically for debugging.}

\item{sigma1}{a vector of implied volatility (without T)}

\item{sd}{numeric, the stdev of the distribution.
Instead, if an ecld or ecd object is provided,
the stdev will be calculated from it.}

\item{n}{numeric, number of lags in \code{ecld.op_U_lag}.}
}
\value{
a numeric vector
}
\description{
The O operator takes a vector of implied volatility \eqn{\sigma_1(k)}
and transforms them to a vector of option state prices.
The V operator takes a vector of option state prices and transforms
them to a vector of implied volatility \eqn{\sigma_1(k)}.
The U operator calculates the log-slope of the option prices.
}
\author{
Stephen H. Lihn
}
\keyword{ogf}

