% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-opt-class.R
\docType{class}
\name{ecop.opt-class}
\alias{ecop.opt-class}
\title{An S4 class to represent the option data and model calculation}
\description{
The \code{ecop.opt} class serves as an object-oriented container for
the type-specific (p or c) option data.
}
\section{Slots}{

\describe{
\item{\code{call}}{the match.call slot}

\item{\code{otype}}{character, option type}

\item{\code{range.from}}{numeric, starting price range}

\item{\code{range.to}}{numeric, ending price range}

\item{\code{momentum}}{numeric, momentum for tranlation (T) operator}

\item{\code{epsilon}}{numeric, asymptotic premium}

\item{\code{k_cusp}}{numeric, the suggested cusp location for poly fit of prices}

\item{\code{ecldOrEcd}}{the ecld/ecd class to calculate theoretical values in local regime}

\item{\code{S}}{underyling price, this can be overriden by conf}

\item{\code{S_raw}}{underyling price (before override)}

\item{\code{strike}}{strike price}

\item{\code{k}}{log-strike price}

\item{\code{V_last}}{last option price}

\item{\code{V_bid}}{bid option price}

\item{\code{V_ask}}{ask option price}

\item{\code{V}}{finalized option price (likely mid-point)}

\item{\code{IV}}{implied volatility from the vendor}
}}

\author{
Stephen H. Lihn
}
\keyword{ecop}
