% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-solve-cusp-asym-method.R
\name{ecd.solve_cusp_asym}
\alias{ecd.solve_cusp_asym}
\title{Trigonometric solution for asymmetric cusp distribution}
\usage{
ecd.solve_cusp_asym(x, beta)
}
\arguments{
\item{x}{Array of x dimension}

\item{beta}{the skew parameter}
}
\value{
Array of y
}
\description{
The simplified trigonometric solution for \eqn{x^2=-y^3-beta*x*y}
}
\examples{
x <- seq(-100,100,by=0.1)
y <- ecd.solve_cusp_asym(x, beta=0.5)
}
\keyword{analytic}
