% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_estimation.R
\name{get_estimation_qsr}
\alias{get_estimation_qsr}
\title{This function allows you to estimate de Income Quintile Share Ratio}
\usage{
get_estimation_qsr(
  data = ech::toy_ech_2018,
  variable = "y_pc_d_r",
  by = NULL,
  ids = NULL,
  estrato = NULL,
  pesoano = "pesoano"
)
}
\arguments{
\item{data}{data.frame}

\item{variable}{Variable name of total income per hour}

\item{by}{data frame column}

\item{ids}{Variable name of cluster}

\item{estrato}{Variable name of strata}

\item{pesoano}{Variable name of weights}
}
\value{
table
}
\description{
This function allows you to estimate de Income Quintile Share Ratio
}
\examples{
\donttest{
toy_ech_2018 <- income_constant_prices(data = ech::toy_ech_2018, index = "IPC", level = "R",
                                       base_month = "01", base_year = "2005")
get_estimation_qsr(data = toy_ech_2018, variable = "y_pc_d_r", pesoano = "pesoano")
}
}
\seealso{
Other estimation: 
\code{\link{get_estimation_gini}()},
\code{\link{get_estimation_gpg}()},
\code{\link{get_estimation_mean}()},
\code{\link{get_estimation_median}()},
\code{\link{get_estimation_ratio}()},
\code{\link{get_estimation_total}()},
\code{\link{set_design}()}
}
\concept{estimation}
