% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet.R
\name{e_leaflet}
\alias{e_leaflet}
\alias{e_leaflet_tile}
\title{Leaflet}
\usage{
e_leaflet(e, roam = TRUE, ...)

e_leaflet_tile(e,
  template = "https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png",
  options = NULL, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{roam}{Whether to allow the user to roam.}

\item{...}{Any other option to pass, check See Also section.}

\item{template}{\code{urlTemplate}, should not be changed.}

\item{options}{List of options, including \code{attribution} and \code{label}.}
}
\description{
Leaflet extension.
}
\note{
Will not render in the RStudio, open in browser.
}
\examples{
\dontrun{
url <- paste0("https://ecomfe.github.io/echarts-examples/",
              "public/data-gl/asset/data/population.json")
data <- jsonlite::fromJSON(url)
data <- as.data.frame(data)
names(data) <- c("lon", "lat", "value")
data$value <- log(data$value)

data \%>\% 
  e_charts(lon) \%>\% 
  e_leaflet() \%>\%
  e_leaflet_tile() \%>\%  
  e_scatter(lat, size = value, coord.system = "leaflet") 
}

}
