% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_lines_3d}
\alias{e_lines_3d}
\alias{e_line_3d}
\alias{e_lines_3d_}
\alias{e_line_3d_}
\title{Lines 3D}
\usage{
e_lines_3d(e, source_lon, source_lat, target_lon, target_lat, source_name,
  target_name, value, name = NULL, coord_system = "globe",
  rm_x = TRUE, rm_y = TRUE, ...)

e_line_3d(e, y, z, name = NULL, coord_system = NULL, rm_x = TRUE,
  rm_y = TRUE, ...)

e_lines_3d_(e, source_lon, source_lat, target_lon, target_lat,
  source_name = NULL, target_name = NULL, value = NULL,
  name = NULL, coord_system = "globe", rm_x = TRUE, rm_y = TRUE,
  ...)

e_line_3d_(e, y, z, name = NULL, coord_system = NULL, rm_x = TRUE,
  rm_y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{source_lon, source_lat, target_lon, target_lat}{coordinates.}

\item{source_name, target_name}{Names of source and target.}

\item{value}{Value of edges.}

\item{name}{name of the serie.}

\item{coord_system}{Coordinate system to use, such as \code{cartesian3D}, or \code{globe}.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}

\item{y, z}{Coordinates of lines.}
}
\description{
Add 3D lines.
}
\examples{
# get data
flights <- read.csv(
  paste0("https://raw.githubusercontent.com/plotly/datasets/",
         "master/2011_february_aa_flight_paths.csv")
)

# Lines 3D
# Globe
# get tetures: echarts4r-assets.john-coene.com
flights \%>\% 
  e_charts() \%>\% 
  e_globe( 
    displacementScale = 0.05
  ) \%>\% 
  e_lines_3d(
    start_lon, 
    start_lat, 
    end_lon, 
    end_lat,
    name = "flights",
    effect = list(show = TRUE)
  ) \%>\% 
  e_legend(FALSE)

# Geo 3D
flights \%>\% 
  e_charts() \%>\% 
  e_geo_3d() \%>\% 
  e_lines_3d(
    start_lon, 
    start_lat, 
    end_lon, 
    end_lat,
    coord_system = "geo3D"
  )
  
# groups
flights$grp <- rep(LETTERS[1:2], 89)

flights \%>\% 
  group_by(grp) \%>\% 
  e_charts() \%>\% 
  e_geo_3d() \%>\% 
  e_lines_3d(
    start_lon, 
    start_lat, 
    end_lon, 
    end_lat,
    coord_system = "geo3D"
  )
 
# line 3D 
df <- data.frame(
  x = 1:100,
  y = runif(100, 10, 25),
  z = rnorm(100, 100, 50)
)

df \%>\% 
  e_charts(x) \%>\% 
  e_line_3d(y, z) \%>\% 
  e_visual_map() \%>\% 
  e_title("nonsense")
  
# timeline
df$grp <- rep(LETTERS[1:5], 20)

df \%>\% 
  group_by(grp) \%>\% 
  e_charts(x) \%>\% 
  e_line_3d(y, z) \%>\% 
  e_visual_map() \%>\% 
  e_title("nonsense")

}
\seealso{
\href{http://echarts.baidu.com/option-gl.html#series-lines3D}{Additional arguments for lines 3D},
 \href{http://echarts.baidu.com/option-gl.html#series-line3D}{Additional arguments for line 3D}

\url{https://echarts4r-assets.john-coene.com}
}
