% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{e_lm}
\alias{e_lm}
\alias{e_glm}
\alias{e_loess}
\title{Smooth}
\usage{
e_lm(
  e,
  formula,
  name = NULL,
  legend = TRUE,
  symbol = "none",
  smooth = TRUE,
  ...
)

e_glm(
  e,
  formula,
  name = NULL,
  legend = TRUE,
  symbol = "none",
  smooth = TRUE,
  ...
)

e_loess(
  e,
  formula,
  name = NULL,
  legend = TRUE,
  symbol = "none",
  smooth = TRUE,
  x_index = 0,
  y_index = 0,
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{formula}{formula to pass to \code{\link{lm}}.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{symbol}{Symbol to use in \code{\link{e_line}}.}

\item{smooth}{Whether to smooth the line.}

\item{...}{Additional arguments to pass to \code{\link{e_line}}.}

\item{x_index}{Indexes of x and y axis.}

\item{y_index}{Indexes of x and y axis.}
}
\description{
Plot formulas.
}
\examples{
iris \%>\% 
  group_by(Species) \%>\% 
  e_charts(Sepal.Length) \%>\% 
  e_scatter(Sepal.Width) \%>\% 
  e_lm(Sepal.Width ~ Sepal.Length) \%>\% 
  e_x_axis(min = 4)
  
mtcars \%>\% 
  e_charts(disp) \%>\% 
  e_scatter(mpg, qsec) \%>\% 
  e_loess(mpg ~ disp, smooth = TRUE, showSymbol = FALSE)

# timeline   
iris \%>\% 
  group_by(Species) \%>\% 
  e_charts(Sepal.Length, timeline = TRUE) \%>\% 
  e_scatter(Sepal.Width) \%>\% 
  e_lm(Sepal.Width ~ Sepal.Length) \%>\% 
  e_x_axis(min = 4, max = 8) \%>\% 
  e_y_axis(max = 5)

}
