% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{e_theme}
\alias{e_theme}
\alias{e_theme_custom}
\alias{e_theme_register}
\title{Themes}
\usage{
e_theme(e, name)

e_theme_custom(e, theme, name = "custom")

e_theme_register(theme, name = "custom")
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{name}{Name of theme.}

\item{theme}{Theme, A json string or a see below.}
}
\description{
Add a custom theme or apply a pre-built one.
}
\details{
The function \code{e_theme_register} can be used to register the theme globally
in R markdown or shiny (UI). This is useful because 1) the \code{e_theme_custom} registers the 
theme every time and is more computationally expensive.
}
\section{Functions}{

\itemize{
 \item{\code{e_theme} - Use a default theme by name.}
 \item{\code{e_theme_custom} - Use a custom theme.}
 \item{\code{e_theme_register} - Register a theme globally in shiny or R markdown.}
}
}

\section{Theme names}{
 
\itemize{
  \item{\code{default}}
  \item{\code{dark}}
  \item{\code{vintage}}
  \item{\code{westeros}}
  \item{\code{essos}}
  \item{\code{wonderland}}
  \item{\code{walden}}
  \item{\code{chalk}}
  \item{\code{infographic}}
  \item{\code{macarons}}
  \item{\code{roma}}
  \item{\code{shine}}
  \item{\code{purple-passion}}
  \item{\code{halloween}}
  \item{\code{auritus}}
  \item{\code{azul}}
  \item{\code{bee-insipired}}
  \item{\code{blue}}
  \item{\code{caravan}}
  \item{\code{carp}}
  \item{\code{cool}}
  \item{\code{dark-blue}}
  \item{\code{dark-bold}}
  \item{\code{dark-digerati}}
  \item{\code{dark-fresh-cut}}
  \item{\code{dark-mushroom}}
  \item{\code{eduardo}}
  \item{\code{forest}}
  \item{\code{fresh-cut}}
  \item{\code{fruit}}
  \item{\code{gray}}
  \item{\code{green}}
  \item{\code{helianthus}}
  \item{\code{inspired}}
  \item{\code{jazz}}
  \item{\code{london}}
  \item{\code{macarons}}
  \item{\code{macarons2}}
  \item{\code{mint}}
  \item{\code{red}}
  \item{\code{red-velvet}}
  \item{\code{royal}}
  \item{\code{sakura}}
  \item{\code{tech-blue}}
}
}

\examples{
mtcars \%>\% 
  e_charts(mpg) \%>\%
  e_line(disp) \%>\% 
  e_area(hp) \%>\% 
  e_x_axis(min = 10) -> p
  
p \%>\% e_theme("chalk")
p \%>\% e_theme_custom('{"color":["#ff715e","#ffaf51"]}')

}
\seealso{
\href{http://echarts.baidu.com/theme-builder/}{create your own theme}.
}
