% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxes.R
\name{echarts4rBox}
\alias{echarts4rBox}
\title{Box}
\usage{
echarts4rBox(
  data,
  x,
  y,
  text = "",
  subtext = "",
  type = c("bar", "line", "scatter", "area", "step"),
  ...,
  color = "#ffffff",
  text_color = "#ffffff",
  background_color = "#293c55",
  step = c("start", "middle", "end"),
  title_args = list(),
  tooltip = list(trigger = "axis")
)
}
\arguments{
\item{data}{A dataframe containing data to plot.}

\item{x, y}{Bare column name of variables to draw.}

\item{text, subtext}{Title and subtitle of box.}

\item{type}{Chart type to draw.}

\item{...}{Additional arguments to pass to the serie.}

\item{color}{Color of chart in box.}

\item{text_color}{Color of text.}

\item{background_color}{Color of box.}

\item{step}{Step method, only used if \code{type = "step"}.}

\item{title_args}{Additional arguments to add to the title.}

\item{tooltip}{Tooltip to use.}
}
\description{
Renders a data box in shiny.
}
\examples{
library(shiny)

ui <- fluidPage(
  fluidRow(
    column(3, echarts4rBoxOutput("box1"))
  )
)

server <- function(input, output) {
  output$box1 <- renderEcharts4rBox({
    echarts4rBox(cars, speed, dist, "Cars", type = "bar")
  })
}

\dontrun{
  shinyApp(ui, server)
}
}
\seealso{
\code{\link{renderEcharts4rBox}}, \code{\link{echarts4rBoxOutput}}
}
