% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{e_map_register}
\alias{e_map_register}
\alias{e_map_register_p}
\alias{e_map_register_ui}
\title{Register map}
\usage{
e_map_register(e, name, json)

e_map_register_p(
  name,
  json,
  async = FALSE,
  session = shiny::getDefaultReactiveDomain()
)

e_map_register_ui(name, json, async = FALSE)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{name}{Name of map, to use in \code{\link{e_map}}.}

\item{json}{\href{https://geojson.org/}{Geojson}.}

\item{async}{Whether to read the file asynchronously.}

\item{session}{A valid Shiny session.}
}
\description{
Register a \href{https://geojson.org/}{geojson} map.
}
\details{
\code{e_map_register_p} is not truly a proxy as it does not require
a chart to function. While the function \code{e_map_register_ui} is meant to
register the map globally in the Shiny UI, not that then \code{json} must be accessible
from the UI (generally www folder).
}
\examples{
\dontrun{
json <- jsonlite::read_json("https://echarts.apache.org/examples/data/asset/geo/USA.json")

USArrests \%>\%
  dplyr::mutate(states = row.names(.)) \%>\%
  e_charts(states) \%>\%
  e_map_register("USA", json) \%>\%
  e_map(Murder, map = "USA") \%>\%
  e_visual_map(Murder)
}

}
