% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ecs.exec}
\alias{ecs.exec}
\title{Shiny: Execute a proxy command}
\usage{
ecs.exec(proxy, cmd = "p_merge")
}
\arguments{
\item{proxy}{A \link{ecs.proxy} object}

\item{cmd}{Name of command, default is \emph{p_merge}\cr
Other proxy commands:\cr
\emph{p_update} - add new series and axes\cr
\emph{p_merge} - add serie features like marks\cr
\emph{p_del_serie} - delete a serie by index or name\cr
\emph{p_del_marks} - delete marks of a serie\cr
\emph{p_append_data} - add data to existing series\cr
\emph{p_dispatch} - send action commands, see \href{https://echarts.apache.org/en/api.html#echartsInstance.dispatchAction}{documentation}}
}
\value{
A proxy object to update the chart.
}
\description{
Once chart changes had been made, they need to be sent back to the widget for display
}
\examples{
if (interactive()) {

library(shiny)
runApp( list(
  ui = fluidPage(
    ecs.output('plot'),
    actionButton('addm', 'Add marks'),
    actionButton('delm', 'Del area+line marks'), HTML('&nbsp; &nbsp; &nbsp; &nbsp;'),
    actionButton('adds', 'Add serie'),
    actionButton('dels', 'Del serie'), HTML('&nbsp; &nbsp; &nbsp; &nbsp;'),
    actionButton('hilit', 'Highlight'),
    actionButton('dnplay', 'Downplay')
  ),
  server = function(input, output, session){

    output$plot <- ecs.render({
      e <- mtcars \%>\% group_by(cyl) \%>\% ec.init()
      e$x$opts$tooltip <- list(list(show=TRUE))
      e$x$opts$series[[1]]$emphasis <- list(focus='series', blurScope='coordinateSystem')
      e
    })

    observeEvent(input$addm, {
      e <- ecs.proxy('plot')
      e$x$opts$series[[1]] = list(
        markPoint = list(data = list(
          list(coord = c(22.5, 140.8)),
          list(coord = c(30.5, 95.1))
        ), itemStyle = list(color='lightblue')
        )
        ,markArea = list(data = list(list(
          list(xAxis = 15),
          list(xAxis = 25)
        ))
        ,silent=TRUE
        ,itemStyle = list(color='pink', opacity=0.2)
        ,label = list(formatter='X-area', position='insideTop')
        )
        ,markLine = list(data = list(list(type='average')))
      )
      e \%>\% ecs.exec() #' ='p_merge'
    })
    observeEvent(input$adds, {
      e <- ecs.proxy('plot')
      e$x$opts$series[[1]] <- list(
        type = 'line', name = 'newLine',
        encode = list(x='mpg', y='disp')
      )
      e \%>\% ecs.exec('p_update')
    })
    observeEvent(input$dels, {
      e <- ecs.proxy('plot')
      e$x$opts$seriesName <- 'newLine'
      #'e$x$opts$seriesIndex <- 4  #' alternative ok
      e \%>\% ecs.exec('p_del_serie')
    })
    observeEvent(input$delm, {
      e <- ecs.proxy('plot')
      e$x$opts$seriesIndex <- 1
      e$x$opts$delMarks <- c('markArea','markLine')
      e \%>\% ecs.exec('p_del_marks')
    })
    observeEvent(input$hilit, {
      e <- ecs.proxy('plot')
      e$x$opts <- list(type='highlight', seriesName='4')
      e \%>\% ecs.exec('p_dispatch')
    })
    observeEvent(input$dnplay, {
      e <- ecs.proxy('plot')
      e$x$opts <- list(type='downplay', seriesName='4')
      e \%>\% ecs.exec('p_dispatch')
    })
  }
))
}

}
\seealso{
\link{ecs.proxy}, \link{ecs.render}, \link{ecs.output}
}
