% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.data}
\alias{ec.data}
\title{ECharts data helper}
\usage{
ec.data(df, format = "dataset", header = TRUE)
}
\arguments{
\item{df}{Chart data in data.frame format, required}

\item{format}{A key on how to format the output list \cr \itemize{
\item 'dataset' = list used in \href{https://echarts.apache.org/en/option.html#dataset.source}{dataset} (default), or in \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data} but without a header.\cr
\item 'values' = list for customized \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data} \cr
\item 'names' = named lists useful for named data like \href{https://echarts.apache.org/en/option.html#series-sankey.links}{sankey links}
}}

\item{header}{Whether the data will have a header with column names or not, default TRUE. Set this to FALSE when used in \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data}.}
}
\value{
A list for \emph{dataset.source}, \emph{series.data} or a list of named lists.
}
\description{
Make ECharts data from a data.frame
}
