% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echo_package_functions.R
\name{calc_tau_and_p_jtk}
\alias{calc_tau_and_p_jtk}
\title{Function to calculate pvalues for replicates using the exact JTK distribution.}
\usage{
calc_tau_and_p_jtk(ref_waveform, times, num_reps, current_gene, jtklist, genes,
  jtk.alt)
}
\arguments{
\item{ref_waveform}{answer to damped oscillator}

\item{times}{vector of time points}

\item{num_reps}{number of replicates}

\item{current_gene}{row number of gene being examined}

\item{jtklist}{exact distribution for JTK}

\item{genes}{data frame of genes with the following specifications: first row is column labels, first column has gene labels/names, and all other columns have expression data. This expression data must be ordered by time point then by replicate, and must have evenly spaced time points. Any missing data must have cells left blank.}

\item{jtk.alt}{contains the exact p-value distribution for replicate data with missing data}
}
\value{
list containing:
\item{pval}{pvalue}
\item{tau}{Kendall's tau}
\item{S}{Kendall's S statistic}
}
\description{
Function to calculate pvalues for replicates using the exact JTK distribution.
}
