% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echo_package_functions.R
\name{genes_unexpressed_all}
\alias{genes_unexpressed_all}
\title{Function for determining whether gene values are unexpressed (less than rem_unexpr_amt percent expressed (i.e., not 0)) for full matrix.}
\usage{
genes_unexpressed_all(rem_unexpr_amt, genes)
}
\arguments{
\item{rem_unexpr_amt}{percentage of expression for which genes should not be considered}

\item{genes}{data frame of genes with the following specifications: first row is column labels, first column has gene labels/names, and all other columns have expression data. This expression data must be ordered by time point then by replicate, and must have evenly spaced time points. Any missing data must have cells left blank.}
}
\value{
boolean if there is rem_unexpr_amt percent expression
}
\description{
Function for determining whether gene values are unexpressed (less than rem_unexpr_amt percent expressed (i.e., not 0)) for full matrix.
}
