% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{dd_est_hmnl_screen}
\alias{dd_est_hmnl_screen}
\title{Estimate discrete choice model (HMNL, attribute-based screening (not including price))}
\usage{
dd_est_hmnl_screen(
  dd,
  price_screen = TRUE,
  R = 1e+05,
  keep = 10,
  cores = NULL,
  control = list(include_data = TRUE)
)
}
\arguments{
\item{dd}{discrete choice data (long format)}

\item{price_screen}{A logical, indicating whether price tag screening should be estimated}

\item{R}{draws}

\item{keep}{thinning}

\item{cores}{no of CPU cores to use (default: auto-detect)}

\item{control}{list containing additional settings}
}
\value{
est ec-draw object (List)
}
\description{
Estimate discrete choice model (HMNL, attribute-based screening (not including price))
}
\examples{
data(icecream_discrete)
icecream_est <- icecream_discrete \%>\% dplyr::filter(id<20) \%>\% 
  dd_est_hmnl_screen(R=20, cores=2)
}
\seealso{
\code{\link[=dd_dem_sr]{dd_dem_sr()}} to generate demand predictions based on this model
}
