% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_archetype.R
\name{wf_archetype}
\alias{wf_archetype}
\title{Creates an archetype function}
\usage{
wf_archetype(request, dynamic_fields)
}
\arguments{
\item{request}{a MARS or CDS request as an R list object.}

\item{dynamic_fields}{character vector of fields that could be changed.}
}
\value{
a function that takes `dynamic_fields` as arguments and returns a
request as an R list object.
}
\description{
Creates a universal MARS / CDS formatting function, in ways
similar to \code{wf_modify_request()} but the added advantage
that you could code for the use of dynamic changes in the
parameters provided to the resulting custom function.
}
\details{
Contrary to a simple replacement as in \code{wf_modify_request()} the
generated functions are considered custom user written. Given the potential
for complex formulations and formatting commands NO SUPPORT for the
resulting functions can be provided. Only the generation of a valid function
will be guaranteed and tested for.
}
\examples{
\dontrun{

ERA <- wf_archetype(
  request = list(
    dataset_short_name = "reanalysis-era5-pressure-levels",
    product_type = "reanalysis",
    variable = "geopotential",
    year = "2024",
    month = "03",
    day = "01",
    time = "13:00",
    pressure_level = "1000",
    data_format = "grib",
    target = "download.grib"
  ),
    dynamic_fields = c("year", "day", "target")
  )
# print output of the function with below (new) parameters
str(ERA(2021, 3, "new_download.grip"))

}
}
