% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_delete.R
\name{wf_delete}
\alias{wf_delete}
\title{Delete ECMWF Data Store request}
\usage{
wf_delete(url, user = "ecmwfr", verbose = TRUE)
}
\arguments{
\item{url}{url to query}

\item{user}{user, generally not set (default = "ecmwfr"), used by \code{\link[ecmwfr]{wf_set_key}}}

\item{verbose}{show feedback on processing}
}
\description{
Deletes a staged download from the queue when not using R6 methods.
}
\examples{

\dontrun{

# demo query using a valid request (not shown)
file <- wf_request(request = request)

# delete request
job_url <- file$get_url()
wf_delete(url = job_url)
}
}
\seealso{
\code{\link[ecmwfr]{wf_set_key}}
\code{\link[ecmwfr]{wf_transfer}}
\code{\link[ecmwfr]{wf_request}}
}
\author{
Koen Hufkens
}
