% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexity_measures.R
\name{complexity_measures}
\alias{complexity_measures}
\title{Complexity Measures}
\usage{
complexity_measures(revealed_comparative_advantage = NULL,
  country = "country", product = "product", value = "value",
  method = "fitness", iterations = 20, extremality = 1,
  keep_atlas = FALSE, tbl_output = FALSE)
}
\arguments{
\item{revealed_comparative_advantage}{matrix or tibble/data.frame (e.g. the output of
\code{revealed_comparative_advantage()}).
If the input is a matrix it must be a zero/one matrix with countries in rows and products in columns.
If the input is a tibble/data.frame it must contain at least three columns with countries, products and
values.}

\item{country}{string to indicate the column that contains exporting countries in revealed_comparative_advantage
(set to "country" by default)}

\item{product}{string to indicate the column that contains exported products in revealed_comparative_advantage
(set to "product" by default)}

\item{value}{string to indicate the column that contains traded values in revealed_comparative_advantage
(set to "value" by default)}

\item{method}{string to indicate to use one of these methods: reflections, eigenvalues or fitness
(set to "fitness" by default)}

\item{iterations}{number of iterations to use in the reflections method (set to 20 by default)}

\item{extremality}{numeric coefficient to use in the fitness method (set to 1 by default)}

\item{keep_atlas}{logical value to remove the countries not ranked in The Atlas of Economic Complexity
(set to FALSE by default)}

\item{tbl_output}{logical value to use tibble output instead of a matrix output (set to FALSE by default)}
}
\description{
Complexity Measures
}
\examples{
complexity_measures(
 revealed_comparative_advantage =
  package_output_demo$revealed_comparative_advantage_matrix,
 tbl_output = TRUE
)
}
\references{
For more information on complexity measures, indices and its applications see:

\insertRef{atlas2014}{economiccomplexity}

\insertRef{measuringcomplexity2015}{economiccomplexity}
}
\keyword{functions}
